/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.backend.ConfigMBean;
import org.jolokia.history.HistoryKey;
import org.jolokia.history.HistoryLimit;
import org.jolokia.history.HistoryStore;
import org.jolokia.util.DebugStore;

public class Config
implements ConfigMBean,
MBeanRegistration {
    private HistoryStore historyStore;
    private DebugStore debugStore;
    private String objectName;

    public Config(HistoryStore pHistoryStore, DebugStore pDebugStore, String pOName) {
        this.historyStore = pHistoryStore;
        this.debugStore = pDebugStore;
        this.objectName = pOName;
    }

    @Override
    public void setHistoryEntriesForAttribute(String pMBean, String pAttribute, String pPath, String pTarget, int pMaxEntries) throws MalformedObjectNameException {
        this.setHistoryLimitForAttribute(pMBean, pAttribute, pPath, pTarget, pMaxEntries, 0L);
    }

    @Override
    public void setHistoryLimitForAttribute(String pMBean, String pAttribute, String pPath, String pTarget, int pMaxEntries, long pMaxDuration) throws MalformedObjectNameException {
        HistoryKey key = new HistoryKey(pMBean, pAttribute, pPath, pTarget);
        this.historyStore.configure(key, this.limitOrNull(pMaxEntries, pMaxDuration));
    }

    @Override
    public void setHistoryEntriesForOperation(String pMBean, String pOperation, String pTarget, int pMaxEntries) throws MalformedObjectNameException {
        this.setHistoryLimitForOperation(pMBean, pOperation, pTarget, pMaxEntries, 0L);
    }

    @Override
    public void setHistoryLimitForOperation(String pMBean, String pOperation, String pTarget, int pMaxEntries, long pMaxDuration) throws MalformedObjectNameException {
        HistoryKey key = new HistoryKey(pMBean, pOperation, pTarget);
        this.historyStore.configure(key, this.limitOrNull(pMaxEntries, pMaxDuration));
    }

    @Override
    public void resetHistoryEntries() {
        this.historyStore.reset();
    }

    @Override
    public String debugInfo() {
        return this.debugStore.debugInfo();
    }

    @Override
    public void resetDebugInfo() {
        this.debugStore.resetDebugInfo();
    }

    @Override
    public int getHistoryMaxEntries() {
        return this.historyStore.getGlobalMaxEntries();
    }

    @Override
    public void setHistoryMaxEntries(int pLimit) {
        this.historyStore.setGlobalMaxEntries(pLimit);
    }

    @Override
    public boolean isDebug() {
        return this.debugStore.isDebug();
    }

    @Override
    public void setDebug(boolean pSwitch) {
        this.debugStore.setDebug(pSwitch);
    }

    @Override
    public int getMaxDebugEntries() {
        return this.debugStore.getMaxDebugEntries();
    }

    @Override
    public void setMaxDebugEntries(int pNumber) {
        this.debugStore.setMaxDebugEntries(pNumber);
    }

    @Override
    public int getHistorySize() {
        return this.historyStore.getSize();
    }

    private HistoryLimit limitOrNull(int pMaxEntries, long pMaxDuration) {
        return pMaxEntries != 0 || pMaxDuration != 0L ? new HistoryLimit(pMaxEntries, pMaxDuration) : null;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return new ObjectName(this.objectName);
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
    }
}

