/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom.address;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;

public class AddressList
extends AbstractList<Address>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<? extends Address> addresses;

    public AddressList(List<? extends Address> addresses, boolean dontCopy) {
        this.addresses = addresses != null ? (dontCopy ? addresses : new ArrayList(addresses)) : Collections.emptyList();
    }

    public AddressList(List<? extends Address> addresses) {
        this(addresses, false);
    }

    public AddressList(Address ... addresses) {
        this.addresses = addresses != null ? Arrays.asList(addresses) : Collections.emptyList();
    }

    @Override
    public int size() {
        return this.addresses.size();
    }

    @Override
    public Address get(int index) {
        return this.addresses.get(index);
    }

    public MailboxList flatten() {
        boolean groupDetected = false;
        for (Address address : this.addresses) {
            if (address instanceof Mailbox) continue;
            groupDetected = true;
            break;
        }
        if (!groupDetected) {
            List<? extends Address> mailboxes = this.addresses;
            return new MailboxList(mailboxes, true);
        }
        ArrayList<Mailbox> results = new ArrayList<Mailbox>();
        for (Address address : this.addresses) {
            address.addMailboxesTo(results);
        }
        return new MailboxList(results, false);
    }
}

