/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.mapper.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.custos.core.model.user.UserAttribute;
import org.apache.custos.core.model.user.UserProfile;
import org.apache.custos.core.model.user.UserRole;
import org.apache.custos.core.user.profile.api.UserProfile;
import org.apache.custos.core.user.profile.api.UserStatus;
import org.apache.custos.core.user.profile.api.UserTypes;

public class UserProfileMapper {
    public static UserProfile createUserProfileEntityFromUserProfile(org.apache.custos.core.user.profile.api.UserProfile userProfile) {
        UserProfile entity = new UserProfile();
        entity.setUsername(userProfile.getUsername());
        userProfile.getEmail();
        if (!userProfile.getEmail().trim().isEmpty()) {
            entity.setEmailAddress(userProfile.getEmail());
        }
        userProfile.getFirstName();
        if (!userProfile.getFirstName().trim().isEmpty()) {
            entity.setFirstName(userProfile.getFirstName());
        }
        userProfile.getLastName();
        if (!userProfile.getLastName().trim().isEmpty()) {
            entity.setLastName(userProfile.getLastName());
        }
        entity.setType(userProfile.getType().name());
        entity.setStatus(userProfile.getStatus().name());
        HashSet<UserAttribute> attributeSet = new HashSet<UserAttribute>();
        if (!userProfile.getAttributesList().isEmpty()) {
            userProfile.getAttributesList().forEach(atr -> {
                if (!atr.getValuesList().isEmpty()) {
                    for (String value : atr.getValuesList()) {
                        UserAttribute userAttribute = new UserAttribute();
                        userAttribute.setKey(atr.getKey());
                        userAttribute.setValue(value);
                        userAttribute.setUserProfile(entity);
                        attributeSet.add(userAttribute);
                    }
                }
            });
        }
        entity.setUserAttribute(attributeSet);
        HashSet<UserRole> userRoleSet = new HashSet<UserRole>();
        if (!userProfile.getRealmRolesList().isEmpty()) {
            userProfile.getRealmRolesList().forEach(role -> {
                UserRole userRole = new UserRole();
                userRole.setValue((String)role);
                userRole.setType("realm");
                userRole.setUserProfile(entity);
                userRoleSet.add(userRole);
            });
        }
        if (!userProfile.getClientRolesList().isEmpty()) {
            userProfile.getClientRolesList().forEach(role -> {
                UserRole userRole = new UserRole();
                userRole.setValue((String)role);
                userRole.setType("client");
                userRole.setUserProfile(entity);
                userRoleSet.add(userRole);
            });
        }
        entity.setUserRole(userRoleSet);
        return entity;
    }

    public static org.apache.custos.core.user.profile.api.UserProfile createUserProfileFromUserProfileEntity(UserProfile profileEntity, String membershipType) {
        UserProfile.Builder builder = org.apache.custos.core.user.profile.api.UserProfile.newBuilder();
        if (profileEntity.getUserRole() != null && !profileEntity.getUserRole().isEmpty()) {
            profileEntity.getUserRole().forEach(role -> {
                if (role.getType().equals("client")) {
                    builder.addClientRoles(role.getValue());
                } else {
                    builder.addRealmRoles(role.getValue());
                }
            });
        }
        ArrayList attributeList = new ArrayList();
        if (profileEntity.getUserAttribute() != null && !profileEntity.getUserAttribute().isEmpty()) {
            HashMap atrMap = new HashMap();
            profileEntity.getUserAttribute().forEach(atr -> {
                atrMap.computeIfAbsent(atr.getKey(), k -> new ArrayList());
                ((List)atrMap.get(atr.getKey())).add(atr.getValue());
            });
            atrMap.keySet().forEach(key -> {
                org.apache.custos.core.user.profile.api.UserAttribute attribute = org.apache.custos.core.user.profile.api.UserAttribute.newBuilder().setKey((String)key).addAllValues((Iterable)atrMap.get(key)).build();
                attributeList.add(attribute);
            });
        }
        builder.setUsername(profileEntity.getUsername()).setCreatedAt(profileEntity.getCreatedAt().getTime()).setLastModifiedAt(profileEntity.getLastModifiedAt() != null ? profileEntity.getLastModifiedAt().getTime() : 0L).setStatus(UserStatus.valueOf(profileEntity.getStatus())).addAllAttributes(attributeList);
        if (profileEntity.getEmailAddress() != null) {
            builder.setEmail(profileEntity.getEmailAddress());
        }
        if (profileEntity.getFirstName() != null) {
            builder.setFirstName(profileEntity.getFirstName());
        }
        if (profileEntity.getLastName() != null) {
            builder.setLastName(profileEntity.getLastName());
        }
        if (membershipType != null) {
            builder.setMembershipType(membershipType);
        }
        if (profileEntity.getType() == null) {
            builder.setType(UserTypes.END_USER);
        } else {
            builder.setType(UserTypes.valueOf(profileEntity.getType()));
        }
        return builder.build();
    }

    public static String getUserInfoInfoAsString(org.apache.custos.core.user.profile.api.UserProfile userProfile) {
        return "username : " + userProfile.getUsername() + "\nemailAddress : " + userProfile.getEmail() + "\nfirstName : " + userProfile.getFirstName() + "\nlastName : " + userProfile.getLastName() + "\n";
    }
}

