/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.util.UriBuilderFactory;

public final class RestClientAdapter
implements HttpExchangeAdapter {
    private final RestClient restClient;

    private RestClientAdapter(RestClient restClient) {
        this.restClient = restClient;
    }

    @Override
    public boolean supportsRequestAttributes() {
        return true;
    }

    @Override
    public void exchange(HttpRequestValues requestValues) {
        this.newRequest(requestValues).retrieve().toBodilessEntity();
    }

    @Override
    public HttpHeaders exchangeForHeaders(HttpRequestValues values) {
        return this.newRequest(values).retrieve().toBodilessEntity().getHeaders();
    }

    @Override
    public <T> T exchangeForBody(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(values).retrieve().body(bodyType);
    }

    @Override
    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues values) {
        return this.newRequest(values).retrieve().toBodilessEntity();
    }

    @Override
    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(values).retrieve().toEntity(bodyType);
    }

    private RestClient.RequestBodySpec newRequest(HttpRequestValues values) {
        RestClient.RequestBodySpec bodySpec;
        HttpMethod httpMethod = values.getHttpMethod();
        Assert.notNull((Object)httpMethod, (String)"HttpMethod is required");
        RestClient.RequestBodyUriSpec uriSpec = this.restClient.method(httpMethod);
        if (values.getUri() != null) {
            bodySpec = (RestClient.RequestBodySpec)uriSpec.uri(values.getUri());
        } else if (values.getUriTemplate() != null) {
            UriBuilderFactory uriBuilderFactory = values.getUriBuilderFactory();
            if (uriBuilderFactory != null) {
                URI uri = uriBuilderFactory.expand(values.getUriTemplate(), values.getUriVariables());
                bodySpec = (RestClient.RequestBodySpec)uriSpec.uri(uri);
            } else {
                bodySpec = (RestClient.RequestBodySpec)uriSpec.uri(values.getUriTemplate(), values.getUriVariables());
            }
        } else {
            throw new IllegalStateException("Neither full URL nor URI template");
        }
        bodySpec.headers(headers -> headers.putAll((Map<? extends String, ? extends List<String>>)((Object)values.getHeaders())));
        if (!values.getCookies().isEmpty()) {
            ArrayList cookies = new ArrayList();
            values.getCookies().forEach((name, cookieValues) -> cookieValues.forEach(value -> {
                HttpCookie cookie = new HttpCookie((String)name, (String)value);
                cookies.add(cookie.toString());
            }));
            bodySpec.header("Cookie", String.join((CharSequence)"; ", cookies));
        }
        if (values.getBodyValue() != null) {
            bodySpec.body(values.getBodyValue());
        }
        return bodySpec;
    }

    public static RestClientAdapter create(RestClient restClient) {
        return new RestClientAdapter(restClient);
    }
}

