/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv.options;

import org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.bookkeeper.api.kv.options.IncrementOption;
import org.apache.bookkeeper.api.kv.options.PutOption;
import org.apache.bookkeeper.api.kv.options.RangeOption;

public final class Options {
    private static final DeleteOption DEFAULT_DELETE_OPTION = new DeleteOption(){

        public Object endKey() {
            return null;
        }

        @Override
        public boolean prevKv() {
            return false;
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "DeleteOption(prevKv=false)";
        }
    };
    private static final DeleteOption DELETE_AND_GET_OPTION = new DeleteOption(){

        public Object endKey() {
            return null;
        }

        @Override
        public boolean prevKv() {
            return true;
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "DeleteOption(prevKv=true)";
        }
    };
    private static final RangeOption GET_OPTION = new RangeOption(){

        @Override
        public long limit() {
            return 1L;
        }

        @Override
        public long minModRev() {
            return Long.MIN_VALUE;
        }

        @Override
        public long maxModRev() {
            return Long.MAX_VALUE;
        }

        @Override
        public long minCreateRev() {
            return Long.MIN_VALUE;
        }

        @Override
        public long maxCreateRev() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean keysOnly() {
            return false;
        }

        @Override
        public boolean countOnly() {
            return false;
        }

        public Object endKey() {
            return null;
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "RangeOption(limit=1)";
        }
    };
    private static final PutOption BLIND_PUT_OPTION = new PutOption(){

        @Override
        public void close() {
        }

        @Override
        public boolean prevKv() {
            return false;
        }

        public String toString() {
            return "PutOption(prevKv=false)";
        }
    };
    private static final PutOption PUT_AND_GET_OPTION = new PutOption(){

        @Override
        public void close() {
        }

        @Override
        public boolean prevKv() {
            return true;
        }

        public String toString() {
            return "PutOption(prevKv=true)";
        }
    };
    private static final IncrementOption BLIND_INCREMENT_OPTION = new IncrementOption(){

        @Override
        public boolean getTotal() {
            return false;
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "IncrementOption(getTotal=false)";
        }
    };
    private static final IncrementOption INCREMENT_AND_GET_OPTION = new IncrementOption(){

        @Override
        public boolean getTotal() {
            return true;
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "IncrementOption(getTotal=true)";
        }
    };

    public static <K> PutOption<K> blindPut() {
        return BLIND_PUT_OPTION;
    }

    public static <K> IncrementOption<K> blindIncrement() {
        return BLIND_INCREMENT_OPTION;
    }

    public static <K> IncrementOption<K> incrementAndGet() {
        return INCREMENT_AND_GET_OPTION;
    }

    public static <K> PutOption<K> putAndGet() {
        return PUT_AND_GET_OPTION;
    }

    public static <K> RangeOption<K> get() {
        return GET_OPTION;
    }

    public static <K> DeleteOption<K> delete() {
        return DEFAULT_DELETE_OPTION;
    }

    public static <K> DeleteOption<K> deleteAndGet() {
        return DELETE_AND_GET_OPTION;
    }

    private Options() {
    }
}

