/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.metric;

import java.util.Map;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.metric.SimpleCounterSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleCounterSetTest
extends ZKTestCase {
    @Test
    public void testValues() {
        SimpleCounterSet simpleCounterSet = this.createSimpleCounterSetAddData("test1");
        Map values = simpleCounterSet.values();
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)30L, values.get("key1_test1"));
        Assertions.assertEquals((Object)70L, values.get("key2_test1"));
    }

    @Test
    public void testReset() {
        SimpleCounterSet simpleCounterSet = this.createSimpleCounterSetAddData("test2");
        simpleCounterSet.reset();
        Map values = simpleCounterSet.values();
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)0L, values.get("key1_test2"));
        Assertions.assertEquals((Object)0L, values.get("key2_test2"));
    }

    private SimpleCounterSet createSimpleCounterSetAddData(String name) {
        SimpleCounterSet simpleCounterSet = new SimpleCounterSet(name);
        simpleCounterSet.add("key1", 10L);
        simpleCounterSet.add("key1", 20L);
        simpleCounterSet.add("key2", 30L);
        simpleCounterSet.add("key2", 40L);
        return simpleCounterSet;
    }
}

