/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.zookeeper.util.CircularBlockingQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestCircularBlockingQueue {
    @Test
    public void testCircularBlockingQueue() throws InterruptedException {
        CircularBlockingQueue testQueue = new CircularBlockingQueue(2);
        testQueue.offer((Object)1);
        testQueue.offer((Object)2);
        testQueue.offer((Object)3);
        Assertions.assertEquals((int)2, (int)testQueue.size());
        Assertions.assertEquals((int)2, (int)((Integer)testQueue.take()));
        Assertions.assertEquals((int)3, (int)((Integer)testQueue.take()));
        Assertions.assertEquals((long)1L, (long)testQueue.getDroppedCount());
        Assertions.assertEquals((int)0, (int)testQueue.size());
        Assertions.assertEquals((Object)true, (Object)testQueue.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testCircularBlockingQueueTakeBlock() throws InterruptedException, ExecutionException {
        CircularBlockingQueue testQueue = new CircularBlockingQueue(2);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Integer> testTake = executor.submit(() -> (Integer)testQueue.take());
            while (!testQueue.isConsumerThreadBlocked()) {
                Thread.sleep(50L);
            }
            testQueue.offer((Object)10);
            Integer result = testTake.get();
            Assertions.assertEquals((int)10, (int)result);
        }
        finally {
            executor.shutdown();
        }
    }
}

