/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;

public class BusyTimedPauser
implements Pauser,
TimingPauser {
    private long time = Long.MAX_VALUE;
    private long countPaused = 0L;

    @Override
    public boolean isBusy() {
        return true;
    }

    @Override
    public void reset() {
        this.time = Long.MAX_VALUE;
    }

    @Override
    public void pause() {
        ++this.countPaused;
        Jvm.nanoPause();
    }

    @Override
    public void pause(long timeout, TimeUnit timeUnit) throws TimeoutException {
        if (this.time == Long.MAX_VALUE) {
            this.time = System.nanoTime();
        }
        if (this.time + timeUnit.toNanos(timeout) - System.nanoTime() < 0L) {
            throw new TimeoutException();
        }
        this.pause();
    }

    @Override
    public void unpause() {
    }

    @Override
    public long timePaused() {
        return 0L;
    }

    @Override
    public long countPaused() {
        return this.countPaused;
    }
}

