/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

public class BufferDecoratedKey
extends DecoratedKey {
    private final ByteBuffer key;

    public BufferDecoratedKey(Token token, ByteBuffer key) {
        super(token);
        assert (key != null);
        this.key = key;
    }

    @Override
    public ByteBuffer getKey() {
        return this.key;
    }

    @Override
    public int getKeyLength() {
        return this.key.remaining();
    }

    public static BufferDecoratedKey fromByteComparable(ByteComparable byteComparable, ByteComparable.Version version, IPartitioner partitioner) {
        return DecoratedKey.fromByteComparable(byteComparable, version, partitioner, (token, keyBytes) -> new BufferDecoratedKey((Token)token, ByteBuffer.wrap(keyBytes)));
    }
}

