/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.io.IOException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.BTreePartitionData;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorSerializer;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.CassandraUInt;
import org.apache.cassandra.utils.btree.BTree;

public class CachedBTreePartition
extends ImmutableBTreePartition
implements CachedPartition {
    private final long createdAtInSec;
    private final int cachedLiveRows;
    private final int rowsWithNonExpiringCells;

    private CachedBTreePartition(TableMetadata metadata, DecoratedKey partitionKey, BTreePartitionData holder, long createdAtInSec, int cachedLiveRows, int rowsWithNonExpiringCells) {
        super(metadata, partitionKey, holder);
        this.createdAtInSec = createdAtInSec;
        this.cachedLiveRows = cachedLiveRows;
        this.rowsWithNonExpiringCells = rowsWithNonExpiringCells;
    }

    public static CachedBTreePartition create(UnfilteredRowIterator iterator, long nowInSec) {
        return CachedBTreePartition.create(iterator, 16, nowInSec);
    }

    public static CachedBTreePartition create(UnfilteredRowIterator iterator, int initialRowCapacity, long nowInSec) {
        BTreePartitionData holder = ImmutableBTreePartition.build(iterator, initialRowCapacity);
        int cachedLiveRows = 0;
        int rowsWithNonExpiringCells = 0;
        boolean enforceStrictLiveness = iterator.metadata().enforceStrictLiveness();
        for (Row row : BTree.iterable(holder.tree)) {
            if (row.hasLiveData(nowInSec, enforceStrictLiveness)) {
                ++cachedLiveRows;
            }
            boolean hasNonExpiringLiveCell = false;
            for (Cell<?> cell : row.cells()) {
                if (cell.isTombstone() || cell.isExpiring()) continue;
                hasNonExpiringLiveCell = true;
                break;
            }
            if (!hasNonExpiringLiveCell) continue;
            ++rowsWithNonExpiringCells;
        }
        return new CachedBTreePartition(iterator.metadata(), iterator.partitionKey(), holder, nowInSec, cachedLiveRows, rowsWithNonExpiringCells);
    }

    @Override
    public int cachedLiveRows() {
        return this.cachedLiveRows;
    }

    @Override
    public int rowsWithNonExpiringCells() {
        return this.rowsWithNonExpiringCells;
    }

    static class Serializer
    implements ISerializer<CachedPartition> {
        Serializer() {
        }

        @Override
        public void serialize(CachedPartition partition, DataOutputPlus out) throws IOException {
            int version = MessagingService.current_version;
            assert (partition instanceof CachedBTreePartition);
            CachedBTreePartition p = (CachedBTreePartition)partition;
            out.writeInt(CassandraUInt.fromLong(p.createdAtInSec));
            out.writeInt(p.cachedLiveRows);
            out.writeInt(p.rowsWithNonExpiringCells);
            partition.metadata().id.serialize(out);
            try (UnfilteredRowIterator iter = p.unfilteredIterator();){
                UnfilteredRowIteratorSerializer.serializer.serialize(iter, null, out, version, p.rowCount());
            }
        }

        @Override
        public CachedPartition deserialize(DataInputPlus in) throws IOException {
            BTreePartitionData holder;
            int version = MessagingService.current_version;
            long createdAtInSec = CassandraUInt.toLong(in.readInt());
            int cachedLiveRows = in.readInt();
            int rowsWithNonExpiringCells = in.readInt();
            TableMetadata metadata = Schema.instance.getExistingTableMetadata(TableId.deserialize(in));
            UnfilteredRowIteratorSerializer.Header header = UnfilteredRowIteratorSerializer.serializer.deserializeHeader(metadata, null, in, version, DeserializationHelper.Flag.LOCAL);
            assert (!header.isReversed && header.rowEstimate >= 0);
            try (UnfilteredRowIterator partition = UnfilteredRowIteratorSerializer.serializer.deserialize(in, version, metadata, DeserializationHelper.Flag.LOCAL, header);){
                holder = ImmutableBTreePartition.build(partition, header.rowEstimate);
            }
            return new CachedBTreePartition(metadata, header.key, holder, createdAtInSec, cachedLiveRows, rowsWithNonExpiringCells);
        }

        @Override
        public long serializedSize(CachedPartition partition) {
            int version = MessagingService.current_version;
            assert (partition instanceof CachedBTreePartition);
            CachedBTreePartition p = (CachedBTreePartition)partition;
            try (UnfilteredRowIterator iter = p.unfilteredIterator();){
                long l = (long)(4 + TypeSizes.sizeof(p.cachedLiveRows) + TypeSizes.sizeof(p.rowsWithNonExpiringCells) + partition.metadata().id.serializedSize()) + UnfilteredRowIteratorSerializer.serializer.serializedSize(iter, null, MessagingService.current_version, p.rowCount());
                return l;
            }
        }
    }
}

