/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.vector;

import io.github.jbellis.jvector.util.RamUsageEstimator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.db.marshal.VectorType;
import org.apache.cassandra.index.sai.disk.v1.vector.RamAwareVectorValues;
import org.apache.cassandra.index.sai.disk.v1.vector.RamEstimation;
import org.apache.cassandra.io.util.SequentialWriter;

@NotThreadSafe
public class CompactionVectorValues
implements RamAwareVectorValues {
    private final int dimension;
    private final ArrayList<ByteBuffer> values = new ArrayList();
    private final VectorType<Float> type;

    public CompactionVectorValues(VectorType<Float> type) {
        this.dimension = type.dimension;
        this.type = type;
    }

    public int size() {
        return this.values.size();
    }

    public int dimension() {
        return this.dimension;
    }

    @Override
    public float[] vectorValue(int i) {
        return this.type.composeAsFloat(this.values.get(i));
    }

    public long add(int ordinal, ByteBuffer value) {
        if (ordinal != this.values.size()) {
            throw new IllegalArgumentException(String.format("CVV requires vectors to be added in ordinal order (%d given, expected %d)", ordinal, this.values.size()));
        }
        this.values.add(value);
        return RamEstimation.concurrentHashMapRamUsed(1) + this.oneVectorBytesUsed();
    }

    public CompactionVectorValues copy() {
        return this;
    }

    public long write(SequentialWriter writer) throws IOException {
        writer.writeInt(this.size());
        writer.writeInt(this.dimension());
        for (int i = 0; i < this.size(); ++i) {
            ByteBuffer bb = this.values.get(i);
            assert (bb != null) : "null vector at index " + i + " of " + this.size();
            writer.write(bb);
        }
        return writer.position();
    }

    public boolean isValueShared() {
        return false;
    }

    private long oneVectorBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }
}

