/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.google.common.base.Preconditions;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.cassandra.bridge.BaseCassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.CassandraVersionFeatures;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.jetbrains.annotations.NotNull;

public final class CassandraBridgeFactory
extends BaseCassandraBridgeFactory {
    private static final Map<String, VersionSpecificBridge> CASSANDRA_BRIDGES = new ConcurrentHashMap<String, VersionSpecificBridge>(CassandraVersion.values().length);

    private CassandraBridgeFactory() {
        throw new IllegalStateException(String.valueOf(((Object)((Object)this)).getClass()) + " is static utility class and shall not be instantiated");
    }

    @NotNull
    public static CassandraBridge get(@NotNull String version) {
        return CassandraBridgeFactory.get(CassandraBridgeFactory.getCassandraVersion((String)version));
    }

    @NotNull
    public static CassandraBridge get(@NotNull CassandraVersionFeatures features) {
        return CassandraBridgeFactory.get(CassandraBridgeFactory.getCassandraVersion((CassandraVersionFeatures)features));
    }

    @NotNull
    public static CassandraBridge get(@NotNull CassandraVersion version) {
        String jarBaseName = version.jarBaseName();
        Preconditions.checkNotNull((Object)jarBaseName, (Object)("Cassandra version " + String.valueOf(version) + " is not supported"));
        return CassandraBridgeFactory.CASSANDRA_BRIDGES.computeIfAbsent((String)jarBaseName, (Function<String, VersionSpecificBridge>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, create(java.lang.String ), (Ljava/lang/String;)Lorg/apache/cassandra/bridge/CassandraBridgeFactory$VersionSpecificBridge;)()).cassandraBridge;
    }

    @NotNull
    public static SparkSqlTypeConverter getSparkSql(@NotNull CassandraVersionFeatures features) {
        return CassandraBridgeFactory.getSparkSql(CassandraBridgeFactory.getCassandraVersion((CassandraVersionFeatures)features));
    }

    @NotNull
    public static SparkSqlTypeConverter getSparkSql(@NotNull CassandraBridge bridge) {
        return CassandraBridgeFactory.getSparkSql(bridge.getVersion());
    }

    @NotNull
    public static SparkSqlTypeConverter getSparkSql(@NotNull CassandraVersion version) {
        String jarBaseName = version.jarBaseName();
        Preconditions.checkNotNull((Object)jarBaseName, (Object)("Cassandra version " + String.valueOf(version) + " is not supported"));
        return CassandraBridgeFactory.CASSANDRA_BRIDGES.computeIfAbsent((String)jarBaseName, (Function<String, VersionSpecificBridge>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, create(java.lang.String ), (Ljava/lang/String;)Lorg/apache/cassandra/bridge/CassandraBridgeFactory$VersionSpecificBridge;)()).sparkSqlTypeConverter;
    }

    @NotNull
    private static String sparkSqlResourceName(@NotNull String label) {
        return CassandraBridgeFactory.jarResourceName((String[])new String[]{label, "sparksql"});
    }

    @NotNull
    private static VersionSpecificBridge create(@NotNull String label) {
        try {
            ClassLoader loader = CassandraBridgeFactory.buildClassLoader((String[])new String[]{CassandraBridgeFactory.cassandraResourceName((String)label), CassandraBridgeFactory.bridgeResourceName((String)label), CassandraBridgeFactory.typesResourceName((String)label), CassandraBridgeFactory.sparkSqlResourceName(label)});
            Class<?> bridge = loader.loadClass("org.apache.cassandra.bridge.CassandraBridgeImplementation");
            Constructor<?> constructor = bridge.getConstructor(new Class[0]);
            CassandraBridge bridgeInstance = (CassandraBridge)constructor.newInstance(new Object[0]);
            Class<?> typeConverter = loader.loadClass("org.apache.cassandra.spark.data.converter.SparkSqlTypeConverterImplementation");
            Constructor<?> typeConverterConstructor = typeConverter.getConstructor(new Class[0]);
            SparkSqlTypeConverter typeConverterInstance = (SparkSqlTypeConverter)typeConverterConstructor.newInstance(new Object[0]);
            return new VersionSpecificBridge(bridgeInstance, typeConverterInstance);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new RuntimeException("Failed to create Cassandra bridge for label " + label, exception);
        }
    }

    public static String maybeQuotedIdentifier(CassandraBridge bridge, boolean quoteIdentifiers, String unquotedName) {
        return quoteIdentifiers ? bridge.maybeQuoteIdentifier(unquotedName) : unquotedName;
    }

    public static class VersionSpecificBridge {
        public final CassandraBridge cassandraBridge;
        public final SparkSqlTypeConverter sparkSqlTypeConverter;

        public VersionSpecificBridge(CassandraBridge cassandraBridge, SparkSqlTypeConverter sparkSqlTypeConverter) {
            this.cassandraBridge = cassandraBridge;
            this.sparkSqlTypeConverter = sparkSqlTypeConverter;
        }
    }
}

