/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.common.request.data.CreateSliceRequestPayload;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.spark.bulkwriter.BulkWriteValidator;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.CancelJobEvent;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CassandraTopologyMonitor;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageStreamResult;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CreatedRestoreSlice;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.ImportCoordinator;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.exception.ImportFailedException;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.apache.cassandra.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImportCompletionCoordinator
implements ImportCoordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportCompletionCoordinator.class);
    private final long startTimeNanos;
    private final CloudStorageDataTransferApi dataTransferApi;
    private final BulkWriteValidator writeValidator;
    private final List<CloudStorageStreamResult> cloudStorageStreamResultList;
    private final JobInfo job;
    private final ScheduledExecutorService scheduler;
    private final CassandraTopologyMonitor cassandraTopologyMonitor;
    private final ReplicationFactor replicationFactor;
    private final StorageTransportExtension extension;
    private final CompletableFuture<Void> firstFailure = new CompletableFuture();
    private final AtomicReference<ImportFailedException> importFailedException = new AtomicReference<Object>(null);
    private final CompletableFuture<Void> terminal = new CompletableFuture();
    private final Map<CompletableFuture<Void>, RequestAndInstance> importFutures = new HashMap<CompletableFuture<Void>, RequestAndInstance>();
    private final AtomicBoolean consistencyLevelReached = new AtomicBoolean(false);
    private final AtomicInteger completedSlices = new AtomicInteger(0);
    private long waitStartNanos;
    private long minSliceSize = Long.MAX_VALUE;
    private long maxSliceSize = Long.MIN_VALUE;
    private int totalSlices;
    private AtomicInteger satisfiedSlices;

    private ImportCompletionCoordinator(long startTimeNanos, BulkWriterContext writerContext, CloudStorageDataTransferApi dataTransferApi, BulkWriteValidator writeValidator, List<CloudStorageStreamResult> cloudStorageStreamResultList, StorageTransportExtension extension, Consumer<CancelJobEvent> onCancelJob) {
        this(startTimeNanos, writerContext, dataTransferApi, writeValidator, cloudStorageStreamResultList, extension, onCancelJob, CassandraTopologyMonitor::new);
    }

    @VisibleForTesting
    ImportCompletionCoordinator(long startTimeNanos, BulkWriterContext writerContext, CloudStorageDataTransferApi dataTransferApi, BulkWriteValidator writeValidator, List<CloudStorageStreamResult> cloudStorageStreamResultList, StorageTransportExtension extension, Consumer<CancelJobEvent> onCancelJob, BiFunction<ClusterInfo, Consumer<CancelJobEvent>, CassandraTopologyMonitor> monitorCreator) {
        this.startTimeNanos = startTimeNanos;
        this.job = writerContext.job();
        this.dataTransferApi = dataTransferApi;
        this.writeValidator = writeValidator;
        this.cloudStorageStreamResultList = cloudStorageStreamResultList;
        this.extension = extension;
        ThreadFactory tf = ThreadUtil.threadFactory((String)"Import completion timeout");
        this.scheduler = Executors.newSingleThreadScheduledExecutor(tf);
        Consumer<CancelJobEvent> wrapped = cancelJobEvent -> {
            this.setImportFailure(new ImportFailedException(cancelJobEvent.reason, cancelJobEvent.exception));
            onCancelJob.accept((CancelJobEvent)cancelJobEvent);
        };
        this.cassandraTopologyMonitor = monitorCreator.apply(writerContext.cluster(), wrapped);
        this.replicationFactor = writerContext.cluster().replicationFactor();
    }

    public static ImportCompletionCoordinator of(long startTimeNanos, BulkWriterContext writerContext, CloudStorageDataTransferApi dataTransferApi, BulkWriteValidator writeValidator, List<CloudStorageStreamResult> resultsAsCloudStorageStreamResults, StorageTransportExtension extension, Consumer<CancelJobEvent> onCancelJob) {
        return new ImportCompletionCoordinator(startTimeNanos, writerContext, dataTransferApi, writeValidator, resultsAsCloudStorageStreamResults, extension, onCancelJob);
    }

    @Override
    public boolean succeeded() {
        return this.consistencyLevelReached.get();
    }

    @Override
    public ImportFailedException failure() {
        return this.importFailedException.get();
    }

    @Override
    public void await() throws ImportFailedException {
        this.writeValidator.setPhase("WaitForImportCompletion");
        try {
            this.awaitInternal();
        }
        catch (Exception ex) {
            throw ImportFailedException.propagate((Throwable)ex);
        }
        finally {
            if (this.terminal.isDone()) {
                LOGGER.info("Concluded the safe termination, given the specified consistency level is satisfied and enough time has been blocked for importing slices.");
            }
            this.cassandraTopologyMonitor.shutdownNow();
            this.importFutures.keySet().forEach(f -> f.cancel(true));
            this.terminal.complete(null);
            this.scheduler.shutdownNow();
        }
    }

    private void awaitInternal() {
        this.prepareToPoll();
        this.startPolling();
        this.waitForCompletion();
    }

    private void prepareToPoll() {
        this.totalSlices = this.cloudStorageStreamResultList.stream().mapToInt(res -> res.createdRestoreSlices.size()).sum();
        this.cloudStorageStreamResultList.stream().flatMap(res -> res.createdRestoreSlices.stream().map(CreatedRestoreSlice::sliceRequestPayload)).mapToLong(slice -> {
            long size = slice.compressedSizeOrZero();
            if (size == 0L) {
                throw new IllegalStateException("Found invalid slice with 0 compressed size. slice: " + String.valueOf(slice));
            }
            return size;
        }).forEach(size -> {
            this.minSliceSize = Math.min(this.minSliceSize, size);
            this.maxSliceSize = Math.max(this.maxSliceSize, size);
        });
        this.satisfiedSlices = new AtomicInteger(0);
        this.waitStartNanos = System.nanoTime();
    }

    private void startPolling() {
        for (CloudStorageStreamResult cloudStorageStreamResult : this.cloudStorageStreamResultList) {
            for (CreatedRestoreSlice createdRestoreSlice : cloudStorageStreamResult.createdRestoreSlices) {
                for (RingInstance instance : cloudStorageStreamResult.passed) {
                    this.createSliceInstanceFuture(createdRestoreSlice, instance);
                }
            }
        }
    }

    private void addCompletionMonitor(CompletableFuture<?> future) {
        future.whenComplete((v, t) -> {
            if (t instanceof CancellationException) {
                RequestAndInstance rai = this.importFutures.get(future);
                LOGGER.info("Cancelled import. instance={} slice={}", (Object)rai.nodeFqdn, (Object)rai.requestPayload);
                return;
            }
            LOGGER.info("Completed slice requests {}/{}", (Object)this.completedSlices.incrementAndGet(), (Object)this.importFutures.keySet().size());
            if (this.satisfiedSlices.get() == this.totalSlices && this.consistencyLevelReached.compareAndSet(false, true)) {
                LOGGER.info("The specified consistency level of the job has been satisfied. consistencyLevel={}", (Object)this.job.getConsistencyLevel());
                long nowNanos = System.nanoTime();
                long timeToAllSatisfiedNanos = nowNanos - this.waitStartNanos;
                long elapsedNanos = nowNanos - this.startTimeNanos;
                long timeoutNanos = ImportCompletionCoordinator.estimateTimeoutNanos(timeToAllSatisfiedNanos, elapsedNanos, this.job.importCoordinatorTimeoutMultiplier(), this.minSliceSize, this.maxSliceSize, this.job.jobTimeoutSeconds());
                if (timeoutNanos > 0L) {
                    LOGGER.info("Continuing to waiting on slices completion in order to prevent Cassandra side streaming as much as possible. The estimated additional wait time is {} seconds.", (Object)TimeUnit.NANOSECONDS.toSeconds(timeoutNanos));
                    this.scheduler.schedule(() -> this.terminal.complete(null), timeoutNanos, TimeUnit.NANOSECONDS);
                } else {
                    this.terminal.complete(null);
                }
            }
        });
    }

    private void waitForCompletion() {
        CompletableFuture.anyOf(this.firstFailure, this.terminal, CompletableFuture.allOf(this.importFutures.keySet().toArray(new CompletableFuture[0]))).join();
        this.validateAllRangesAreSatisfied();
    }

    static long estimateTimeoutNanos(long timeToAllSatisfiedNanos, long elapsedNanos, double importCoordinatorTimeoutMultiplier, double minSliceSize, double maxSliceSize, long jobTimeoutSeconds) {
        long timeoutNanos = timeToAllSatisfiedNanos;
        double estimatedRateFloor = minSliceSize / (double)timeToAllSatisfiedNanos;
        double timeEstimateBasedOnRate = maxSliceSize / estimatedRateFloor;
        double estimate = Math.max(timeEstimateBasedOnRate, (double)timeoutNanos);
        timeoutNanos = (long)Math.ceil(importCoordinatorTimeoutMultiplier * estimate);
        if (jobTimeoutSeconds != -1L) {
            long remainingTimeoutNanos = TimeUnit.SECONDS.toNanos(jobTimeoutSeconds) - elapsedNanos;
            if (remainingTimeoutNanos <= 0L) {
                return 0L;
            }
            timeoutNanos = Math.min(timeoutNanos, remainingTimeoutNanos);
        }
        if (TimeUnit.NANOSECONDS.toHours(timeoutNanos) > 1L) {
            LOGGER.warn("The additional time to wait is more than 1 hour. timeout={} seconds", (Object)TimeUnit.NANOSECONDS.toSeconds(timeoutNanos));
        }
        return timeoutNanos;
    }

    private void createSliceInstanceFuture(CreatedRestoreSlice createdRestoreSlice, RingInstance instance) {
        if (this.firstFailure.isCompletedExceptionally()) {
            LOGGER.warn("The job has failed already. Skip sending import request. instance={} slice={}", (Object)instance.nodeName(), (Object)createdRestoreSlice.sliceRequestPayload());
            return;
        }
        SidecarInstance sidecarInstance = Sidecar.toSidecarInstance((CassandraInstance)instance, (int)this.job.effectiveSidecarPort());
        CreateSliceRequestPayload createSliceRequestPayload = createdRestoreSlice.sliceRequestPayload();
        CompletionStage<Void> fut = this.dataTransferApi.createRestoreSliceFromDriver(sidecarInstance, createSliceRequestPayload);
        fut = fut.handleAsync((ignored, throwable) -> {
            if (throwable == null) {
                this.handleSuccessfulSliceInstance(createdRestoreSlice, instance, createSliceRequestPayload);
            } else {
                this.handleFailedSliceInstance(instance, createSliceRequestPayload, (Throwable)throwable);
            }
            return null;
        });
        this.addCompletionMonitor((CompletableFuture<?>)fut);
        this.importFutures.put((CompletableFuture<Void>)fut, new RequestAndInstance(createSliceRequestPayload, instance.nodeName()));
    }

    private void handleFailedSliceInstance(RingInstance instance, CreateSliceRequestPayload createSliceRequestPayload, Throwable throwable) {
        LOGGER.warn("Import failed. instance={} slice={}", new Object[]{instance.nodeName(), createSliceRequestPayload, throwable});
        Range range = Range.closed((Comparable)createSliceRequestPayload.firstToken(), (Comparable)createSliceRequestPayload.endToken());
        this.writeValidator.updateFailureHandler((Range<BigInteger>)range, instance, "Failed to import slice. " + throwable.getMessage());
        try {
            this.writeValidator.validateClOrFail(this.cassandraTopologyMonitor.initialTopology(), false);
        }
        catch (RuntimeException rte) {
            this.setImportFailure(ImportFailedException.propagate((Throwable)rte));
        }
    }

    private void handleSuccessfulSliceInstance(CreatedRestoreSlice createdRestoreSlice, RingInstance instance, CreateSliceRequestPayload createSliceRequestPayload) {
        LOGGER.info("Import succeeded. instance={} slice={}", (Object)instance.nodeName(), (Object)createSliceRequestPayload);
        createdRestoreSlice.addSucceededInstance(instance);
        if (CreatedRestoreSlice.ConsistencyLevelCheckResult.SATISFIED == createdRestoreSlice.checkForConsistencyLevel(this.job.getConsistencyLevel(), this.replicationFactor, this.job.getLocalDC())) {
            this.satisfiedSlices.incrementAndGet();
            try {
                this.extension.onObjectApplied(createSliceRequestPayload.bucket(), createSliceRequestPayload.key(), createSliceRequestPayload.compressedSizeOrZero(), System.nanoTime() - this.startTimeNanos);
            }
            catch (Throwable t) {
                LOGGER.warn("StorageTransportExtension fails to process ObjectApplied notification", t);
            }
        }
    }

    private void validateAllRangesAreSatisfied() {
        ArrayList<CreatedRestoreSlice> unsatisfiedSlices = new ArrayList<CreatedRestoreSlice>();
        for (CloudStorageStreamResult cloudStorageStreamResult : this.cloudStorageStreamResultList) {
            for (CreatedRestoreSlice createdRestoreSlice : cloudStorageStreamResult.createdRestoreSlices) {
                if (CreatedRestoreSlice.ConsistencyLevelCheckResult.NOT_SATISFIED != createdRestoreSlice.checkForConsistencyLevel(this.job.getConsistencyLevel(), this.replicationFactor, this.job.getLocalDC())) continue;
                unsatisfiedSlices.add(createdRestoreSlice);
            }
        }
        if (!unsatisfiedSlices.isEmpty()) {
            String message = String.format("Some of the token ranges cannot satisfy with consistency level. job=%s phase=%s consistencyLevel=%s ranges=%s", this.job.getRestoreJobId(), this.writeValidator.getPhase(), this.job.getConsistencyLevel(), unsatisfiedSlices);
            LOGGER.error(message);
            throw new ImportFailedException(message);
        }
        LOGGER.info("All token ranges have satisfied with consistency level. consistencyLevel={} phase={}", (Object)this.job.getConsistencyLevel(), (Object)this.writeValidator.getPhase());
    }

    private void setImportFailure(ImportFailedException failure) {
        if (this.importFailedException.compareAndSet(null, failure)) {
            this.firstFailure.completeExceptionally((Throwable)failure);
        }
    }

    @VisibleForTesting
    Map<CompletableFuture<Void>, RequestAndInstance> importFutures() {
        return this.importFutures;
    }

    static class RequestAndInstance {
        final String nodeFqdn;
        final CreateSliceRequestPayload requestPayload;

        RequestAndInstance(CreateSliceRequestPayload requestPayload, String nodeFqdn) {
            this.nodeFqdn = nodeFqdn;
            this.requestPayload = requestPayload;
        }
    }
}

