/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.Int32Serializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Int32Type
extends NumberType<Integer> {
    public static final Int32Type instance = new Int32Type();

    Int32Type() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        int diff = accessorL.getByte(left, 0) - accessorR.getByte(right, 0);
        if (diff != 0) {
            return diff;
        }
        return ValueAccessor.compare(left, accessorL, right, accessorR);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        int int32Type;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            int32Type = Integer.parseInt(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("Unable to make int from '%s'", source), e);
        }
        return this.decompose(int32Type);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            if (parsed instanceof String) {
                return new Constants.Value(this.fromString((String)parsed));
            }
            Number parsedNumber = (Number)parsed;
            if (!(parsedNumber instanceof Integer)) {
                throw new MarshalException(String.format("Expected an int value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
            }
            return new Constants.Value(this.getSerializer().serialize(parsedNumber.intValue()));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected an int value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return Objects.toString(this.getSerializer().deserialize(buffer), "\"\"");
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.INT;
    }

    @Override
    public TypeSerializer<Integer> getSerializer() {
        return Int32Serializer.instance;
    }

    @Override
    public int valueLengthIfFixed() {
        return 4;
    }

    @Override
    protected int toInt(ByteBuffer value) {
        return ByteBufferUtil.toInt(value);
    }

    @Override
    protected float toFloat(ByteBuffer value) {
        return this.toInt(value);
    }

    @Override
    public ByteBuffer add(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toInt(left) + rightType.toInt(right));
    }

    @Override
    public ByteBuffer substract(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toInt(left) - rightType.toInt(right));
    }

    @Override
    public ByteBuffer multiply(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toInt(left) * rightType.toInt(right));
    }

    @Override
    public ByteBuffer divide(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toInt(left) / rightType.toInt(right));
    }

    @Override
    public ByteBuffer mod(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toInt(left) % rightType.toInt(right));
    }

    @Override
    public ByteBuffer negate(ByteBuffer input) {
        return ByteBufferUtil.bytes(-this.toInt(input));
    }
}

