/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.unix.Errors;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.transport.CQLMessageHandler;
import org.apache.cassandra.transport.Envelope;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlers {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlers.class);

    public static ChannelInboundHandlerAdapter postV5Handler(FrameEncoder.PayloadAllocator allocator, ProtocolVersion version) {
        return new PostV5ExceptionHandler(allocator, version);
    }

    static final class UnexpectedChannelExceptionHandler
    implements Predicate<Throwable> {
        private static final Set<String> ioExceptionsAtDebugLevel = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("Connection reset by peer")).add("Broken pipe")).add("Connection timed out")).build();
        private final Channel channel;
        private final boolean alwaysLogAtError;

        UnexpectedChannelExceptionHandler(Channel channel, boolean alwaysLogAtError) {
            this.channel = channel;
            this.alwaysLogAtError = alwaysLogAtError;
        }

        @Override
        public boolean apply(Throwable exception) {
            String message;
            try {
                message = "Unexpected exception during request; channel = " + this.channel;
            }
            catch (Exception ignore) {
                message = "Unexpected exception during request; channel = <unprintable>";
            }
            if (!this.alwaysLogAtError && (exception instanceof IOException || exception.getCause() instanceof IOException)) {
                String errorMessage = exception.getMessage();
                boolean logAtTrace = false;
                for (String ioException : ioExceptionsAtDebugLevel) {
                    if (!errorMessage.contains(ioException)) continue;
                    logAtTrace = true;
                    break;
                }
                if (logAtTrace) {
                    logger.trace(message, exception);
                } else {
                    logger.info(message, exception);
                }
            } else {
                logger.error(message, exception);
            }
            return true;
        }
    }

    private static final class PostV5ExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private final FrameEncoder.PayloadAllocator allocator;
        private final ProtocolVersion version;

        public PostV5ExceptionHandler(FrameEncoder.PayloadAllocator allocator, ProtocolVersion version) {
            this.allocator = allocator;
            this.version = version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx.channel().isOpen()) {
                UnexpectedChannelExceptionHandler handler = new UnexpectedChannelExceptionHandler(ctx.channel(), false);
                ErrorMessage errorMessage = ErrorMessage.fromException(cause, handler);
                Envelope response = errorMessage.encode(this.version);
                FrameEncoder.Payload payload = this.allocator.allocate(true, CQLMessageHandler.envelopeSize(response.header));
                try {
                    response.encodeInto(payload.buffer);
                    response.release();
                    payload.finish();
                    ChannelPromise promise = ctx.newPromise();
                    if (PostV5ExceptionHandler.isFatal(cause)) {
                        promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> ctx.close()));
                    }
                    ctx.writeAndFlush(payload, promise);
                }
                finally {
                    payload.release();
                    JVMStabilityInspector.inspectThrowable(cause);
                }
            }
            if (Throwables.anyCauseMatches(cause, t -> t instanceof ProtocolException)) {
                if (Throwables.anyCauseMatches(cause, t -> t instanceof ProtocolException && !((ProtocolException)t).isSilent())) {
                    ClientMetrics.instance.markProtocolException();
                    NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, "Protocol exception with client networking: " + cause.getMessage(), new Object[0]);
                }
            } else if (Throwables.anyCauseMatches(cause, t -> t instanceof Errors.NativeIoException)) {
                ClientMetrics.instance.markUnknownException();
                logger.trace("Native exception in client networking", cause);
            } else if (Throwables.anyCauseMatches(cause, t -> t instanceof SSLException)) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, "SSLException in client networking with peer {} {}", ctx.channel().remoteAddress(), cause.getMessage());
            } else {
                ClientMetrics.instance.markUnknownException();
                logger.warn("Unknown exception in client networking with peer {} {}", (Object)ctx.channel().remoteAddress(), (Object)cause.getMessage());
            }
        }

        private static boolean isFatal(Throwable cause) {
            return Throwables.anyCauseMatches(cause, t -> t instanceof ProtocolException && ((ProtocolException)t).isFatal());
        }
    }
}

