/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.net.ResourceLimits;
import org.apache.cassandra.transport.ClientResourceLimits;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.Envelope;
import org.apache.cassandra.transport.ExceptionHandlers;
import org.apache.cassandra.transport.Flusher;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreV5Handlers {
    private static ProtocolVersion getConnectionVersion(ChannelHandlerContext ctx) {
        Connection connection = ctx.channel().attr(Connection.attributeKey).get();
        return connection == null ? ProtocolVersion.CURRENT : connection.getVersion();
    }

    @ChannelHandler.Sharable
    public static final class ExceptionHandler
    extends ChannelInboundHandlerAdapter {
        public static final ExceptionHandler instance = new ExceptionHandler();

        private ExceptionHandler() {
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx.channel().isOpen()) {
                ExceptionHandlers.UnexpectedChannelExceptionHandler handler = new ExceptionHandlers.UnexpectedChannelExceptionHandler(ctx.channel(), false);
                ErrorMessage errorMessage = ErrorMessage.fromException(cause, handler);
                ChannelFuture future = ctx.writeAndFlush(errorMessage.encode(PreV5Handlers.getConnectionVersion(ctx)));
                if (ExceptionHandler.isFatal(cause)) {
                    future.addListener(f -> ctx.close());
                }
            }
            if (Throwables.anyCauseMatches(cause, t -> t instanceof ProtocolException)) {
                if (Throwables.anyCauseMatches(cause, t -> t instanceof ProtocolException && !((ProtocolException)t).isSilent())) {
                    ClientMetrics.instance.markProtocolException();
                    NoSpamLogger.log(Message.logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, "Protocol exception with client networking: " + cause.getMessage(), new Object[0]);
                }
            } else {
                ClientMetrics.instance.markUnknownException();
                Message.logger.warn("Unknown exception in client networking", cause);
            }
            JVMStabilityInspector.inspectThrowable(cause);
        }

        private static boolean isFatal(Throwable cause) {
            return cause instanceof ProtocolException;
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolEncoder
    extends MessageToMessageEncoder<Message> {
        public static final ProtocolEncoder instance = new ProtocolEncoder();

        private ProtocolEncoder() {
        }

        @Override
        public void encode(ChannelHandlerContext ctx, Message source, List results) {
            ProtocolVersion version = PreV5Handlers.getConnectionVersion(ctx);
            results.add(source.encode(version));
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolDecoder
    extends MessageToMessageDecoder<Envelope> {
        public static final ProtocolDecoder instance = new ProtocolDecoder();

        private ProtocolDecoder() {
        }

        @Override
        public void decode(ChannelHandlerContext ctx, Envelope source, List results) {
            try {
                ProtocolVersion version = PreV5Handlers.getConnectionVersion(ctx);
                if (source.header.version != version) {
                    throw new ProtocolException(String.format("Invalid message version. Got %s but previous messages on this connection had version %s", source.header.version, version));
                }
                results.add(Message.Decoder.decodeMessage(ctx.channel(), source));
            }
            catch (Throwable ex) {
                source.release();
                throw ErrorMessage.wrap(ex, source.header.streamId);
            }
        }
    }

    public static class LegacyDispatchHandler
    extends SimpleChannelInboundHandler<Message.Request> {
        private static final Logger logger = LoggerFactory.getLogger(LegacyDispatchHandler.class);
        private final Dispatcher dispatcher;
        private final ClientResourceLimits.Allocator endpointPayloadTracker;
        private long channelPayloadBytesInFlight;
        private boolean paused;

        LegacyDispatchHandler(Dispatcher dispatcher, ClientResourceLimits.Allocator endpointPayloadTracker) {
            this.dispatcher = dispatcher;
            this.endpointPayloadTracker = endpointPayloadTracker;
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, Message.Request request) throws Exception {
            if (this.shouldHandleRequest(ctx, request)) {
                this.dispatcher.dispatch(ctx.channel(), request, this::toFlushItem);
            }
        }

        private Flusher.FlushItem.Unframed toFlushItem(Channel channel, Message.Request request, Message.Response response) {
            return new Flusher.FlushItem.Unframed(channel, response, request.getSource(), this::releaseItem);
        }

        private void releaseItem(Flusher.FlushItem<Message.Response> item) {
            long itemSize = item.request.header.bodySizeInBytes;
            item.request.release();
            this.channelPayloadBytesInFlight -= itemSize;
            ResourceLimits.Outcome endpointGlobalReleaseOutcome = this.endpointPayloadTracker.release(itemSize);
            ChannelConfig config = item.channel.config();
            if (this.paused && (this.channelPayloadBytesInFlight == 0L || endpointGlobalReleaseOutcome == ResourceLimits.Outcome.BELOW_LIMIT)) {
                this.paused = false;
                ClientMetrics.instance.unpauseConnection();
                config.setAutoRead(true);
            }
        }

        private boolean shouldHandleRequest(ChannelHandlerContext ctx, Message.Request request) {
            long requestSize = request.getSource().header.bodySizeInBytes;
            if (this.endpointPayloadTracker.tryAllocate(requestSize) != ResourceLimits.Outcome.SUCCESS) {
                if (request.connection.isThrowOnOverload()) {
                    ClientMetrics.instance.markRequestDiscarded();
                    logger.trace("Discarded request of size: {}. InflightChannelRequestPayload: {}, {}, Request: {}", new Object[]{requestSize, this.channelPayloadBytesInFlight, this.endpointPayloadTracker.toString(), request});
                    throw ErrorMessage.wrap(new OverloadedException("Server is in overloaded state. Cannot accept more requests at this point"), request.getSource().header.streamId);
                }
                this.endpointPayloadTracker.allocate(requestSize);
                ctx.channel().config().setAutoRead(false);
                ClientMetrics.instance.pauseConnection();
                this.paused = true;
            }
            this.channelPayloadBytesInFlight += requestSize;
            return true;
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            this.endpointPayloadTracker.release();
            if (this.paused) {
                this.paused = false;
                ClientMetrics.instance.unpauseConnection();
            }
            ctx.fireChannelInactive();
        }
    }
}

