/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.jfr;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.gridkit.jvmtool.event.EventDumpParser;

public class JfrDumpParserBootstrapper {
    private static final String PARSER_PACKAGE = "org.gridkit.jvmtool.jfr.parser";
    private static final String PARSER_CLASS = "org.gridkit.jvmtool.jfr.parser.JfrDumpParser";
    List<URL> jmcPath = new ArrayList<URL>();

    public EventDumpParser load() {
        String javaHome = System.getProperty("java.home");
        File f = new File(javaHome);
        File jmcp = this.mcpath(f);
        if (!this.mcpath(f).isDirectory() && javaHome.endsWith("jre") && this.mcpath(f = new File(javaHome.substring(0, javaHome.length() - 4))).isDirectory()) {
            jmcp = this.mcpath(f);
        }
        if (jmcp.isDirectory() && jmcp.listFiles() != null) {
            for (File j : jmcp.listFiles()) {
                try {
                    if (j.isFile() && j.getName().startsWith("com.jrockit.mc.common") && j.getName().endsWith(".jar")) {
                        this.jmcPath.add(j.toURI().toURL());
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                try {
                    if (!j.isFile() || !j.getName().startsWith("com.jrockit.mc.flightrecorder") || !j.getName().endsWith(".jar")) continue;
                    this.jmcPath.add(j.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        if (this.jmcPath.isEmpty()) {
            return null;
        }
        this.jmcPath.addAll(Arrays.asList(((URLClassLoader)this.getClass().getClassLoader()).getURLs()));
        JmcClassLoader cl = new JmcClassLoader(this.jmcPath.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        try {
            return new Instantiator(cl).call();
        }
        catch (Throwable e) {
            try {
                return new Instantiator(Thread.currentThread().getContextClassLoader()).call();
            }
            catch (Throwable e2) {
                return null;
            }
        }
    }

    private File mcpath(File f) {
        return new File(new File(new File(f, "lib"), "missioncontrol"), "plugins");
    }

    static class Instantiator
    implements Callable<EventDumpParser> {
        final ClassLoader cl;

        public Instantiator(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public EventDumpParser call() throws Exception {
            return (EventDumpParser)this.cl.loadClass(JfrDumpParserBootstrapper.PARSER_CLASS).newInstance();
        }
    }

    static class JmcClassLoader
    extends URLClassLoader {
        private final ClassLoader baseClassloader;

        public JmcClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, (ClassLoader)null);
            this.baseClassloader = parent;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.shouldLoad(name)) {
                String bytepath = name.replace('.', '/') + ".class";
                URL url = this.getResource(bytepath);
                if (url == null) {
                    throw new ClassNotFoundException(name);
                }
                Class<?> cl = this.findLoadedClass(name);
                if (cl == null) {
                    cl = this.findClass(name);
                }
                if (cl == null) {
                    throw new ClassNotFoundException(name);
                }
                return cl;
            }
            Class<?> cc = this.baseClassloader.loadClass(name);
            return cc;
        }

        private boolean shouldLoad(String name) {
            return name.startsWith(JfrDumpParserBootstrapper.PARSER_PACKAGE) || name.startsWith("com.jrockit");
        }
    }
}

