/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.hyperic.sigar.Sigar;

public class SigarLog {
    private static final int LOG_FATAL = 0;
    private static final int LOG_ERROR = 1;
    private static final int LOG_WARN = 2;
    private static final int LOG_INFO = 3;
    private static final int LOG_DEBUG = 4;

    private static native void setLogger(Sigar var0, Logger var1);

    public static native void setLevel(Sigar var0, int var1);

    private static boolean isLogConfigured() {
        return Logger.getRootLogger().getAllAppenders().hasMoreElements();
    }

    private static Logger getLogger() {
        return SigarLog.getLogger("Sigar");
    }

    public static Logger getLogger(String name) {
        Logger log = Logger.getLogger(name);
        if (!SigarLog.isLogConfigured()) {
            BasicConfigurator.configure();
        }
        return log;
    }

    static void error(String msg, Throwable exc) {
        SigarLog.getLogger().error(msg, exc);
    }

    static void debug(String msg, Throwable exc) {
        SigarLog.getLogger().debug(msg, exc);
    }

    public static void enable(Sigar sigar) {
        Logger log = SigarLog.getLogger();
        Level level = log.getLevel();
        if (level == null && (level = Logger.getRootLogger().getLevel()) == null) {
            return;
        }
        switch (level.toInt()) {
            case 50000: {
                SigarLog.setLevel(sigar, 0);
                break;
            }
            case 40000: {
                SigarLog.setLevel(sigar, 1);
                break;
            }
            case 30000: {
                SigarLog.setLevel(sigar, 2);
                break;
            }
            case 20000: {
                SigarLog.setLevel(sigar, 3);
                break;
            }
            case 10000: {
                SigarLog.setLevel(sigar, 4);
            }
        }
        SigarLog.setLogger(sigar, log);
    }

    public static void disable(Sigar sigar) {
        SigarLog.setLogger(sigar, null);
    }
}

