/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.replacement;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.analytics.TestUninterruptibles;
import org.apache.cassandra.analytics.replacement.HostReplacementTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

class HostReplacementMultiDCFailureTest
extends HostReplacementTestBase {
    static final QualifiedName QUALIFIED_NAME = HostReplacementMultiDCFailureTest.uniqueTestTableFullName("spark_test", ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.LOCAL_QUORUM);

    HostReplacementMultiDCFailureTest() {
    }

    @Test
    void nodeReplacementFailureMultiDC() {
        this.bulkWriterDataFrameWriter((Dataset<Row>)this.df, QUALIFIED_NAME).option(WriterOptions.BULK_WRITER_CL.name(), ConsistencyLevel.LOCAL_QUORUM.name()).save();
    }

    protected void beforeClusterShutdown() {
        Stream<Arguments> testInputs = Stream.of(Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.LOCAL_QUORUM)}));
        this.completeTransitionsAndValidateWrites(BBHelperReplacementFailureMultiDC.transitionalStateEnd, testInputs, true);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF2_DC2_RF2);
        this.createTestTable(QUALIFIED_NAME, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return HostReplacementMultiDCFailureTest.clusterConfig().nodesPerDc(3).newNodesPerDc(1).dcCount(2).requestFeature(Feature.NETWORK).instanceInitializer(BBHelperReplacementFailureMultiDC::install);
    }

    @Override
    protected CountDownLatch nodeStart() {
        return BBHelperReplacementFailureMultiDC.nodeStart;
    }

    public static class BBHelperReplacementFailureMultiDC {
        static final CountDownLatch nodeStart = new CountDownLatch(1);
        static final CountDownLatch transitionalStateStart = new CountDownLatch(1);
        static final CountDownLatch transitionalStateEnd = new CountDownLatch(1);

        public static void install(ClassLoader cl, Integer nodeNumber) {
            if (nodeNumber == 7) {
                TypePool typePool = TypePool.Default.of((ClassLoader)cl);
                TypeDescription description = typePool.describe("org.apache.cassandra.service.StorageService").resolve();
                new ByteBuddy().rebase(description, ClassFileLocator.ForClassLoader.of((ClassLoader)cl)).method((ElementMatcher)ElementMatchers.named((String)"bootstrap").and((ElementMatcher)ElementMatchers.takesArguments((int)2))).intercept((Implementation)MethodDelegation.to(BBHelperReplacementFailureMultiDC.class)).make((TypeResolutionStrategy)TypeResolutionStrategy.Lazy.INSTANCE, typePool).load(cl, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }

        public static boolean bootstrap(Collection<?> tokens, long bootstrapTimeoutMillis, @SuperCall Callable<Boolean> orig) throws Exception {
            boolean result = orig.call();
            nodeStart.countDown();
            transitionalStateStart.countDown();
            TestUninterruptibles.awaitUninterruptiblyOrThrow(transitionalStateEnd, 2L, TimeUnit.MINUTES);
            throw new UnsupportedOperationException("Simulated failure");
        }
    }
}

