/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.clients;

import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class SidecarInstanceTest {
    protected abstract SidecarInstance newInstance(String var1, int var2);

    @Test
    public void failsWithInvalidPortNumber() {
        int[] invalidPortNumbers;
        for (int invalidPortNumber : invalidPortNumbers = new int[]{-1, 0, 65536}) {
            try {
                this.newInstance(null, invalidPortNumber);
                Assertions.fail((String)"Expected to throw AssertionError when port is invalid");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assertions.assertThat((String)illegalArgumentException.getMessage()).isEqualTo("Invalid port number for the Sidecar service: " + invalidPortNumber);
            }
        }
    }

    @Test
    public void failsWithNullHostname() {
        try {
            this.newInstance(null, 8080);
            Assertions.fail((String)"Expected to throw NullPointerException when hostname is null");
        }
        catch (NullPointerException npe) {
            Assertions.assertThat((String)npe.getMessage()).isEqualTo("The Sidecar hostname must be non-null");
        }
    }

    @Test
    public void testConstructorWithValidParameters() {
        SidecarInstance instance1 = this.newInstance("localhost", 8080);
        Assertions.assertThat((Object)instance1).isNotNull();
        Assertions.assertThat((int)instance1.port()).isEqualTo(8080);
        Assertions.assertThat((String)instance1.hostname()).isEqualTo("localhost");
        SidecarInstance instance2 = this.newInstance("127.0.0.1", 1234);
        Assertions.assertThat((Object)instance2).isNotNull();
        Assertions.assertThat((int)instance2.port()).isEqualTo(1234);
        Assertions.assertThat((String)instance2.hostname()).isEqualTo("127.0.0.1");
    }
}

