/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.http.impl;

import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.HttpHeaders;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.HttpServerRequest;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.ServerWebSocket;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.Http1xServerRequest;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.HttpServerConnectionHandler;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.ServerWebSocketImpl;

public class Http1xServerRequestHandler
implements Handler<HttpServerRequest> {
    private final HttpServerConnectionHandler handlers;

    public Http1xServerRequestHandler(HttpServerConnectionHandler handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handle(HttpServerRequest req) {
        Handler<ServerWebSocket> wsHandler = this.handlers.wsHandler;
        Handler<HttpServerRequest> reqHandler = this.handlers.requestHandler;
        if (wsHandler != null) {
            if (req.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true) && this.handlers.server.wsAccept()) {
                ((Http1xServerRequest)req).webSocket().onComplete(ar -> {
                    if (ar.succeeded()) {
                        ServerWebSocketImpl ws = (ServerWebSocketImpl)ar.result();
                        wsHandler.handle(ws);
                        ws.tryHandshake(101);
                    }
                });
            } else if (reqHandler != null) {
                reqHandler.handle(req);
            } else {
                req.response().setStatusCode(400).end();
            }
        } else if (req.version() == null) {
            req.response().setStatusCode(501).end();
            req.response().close();
        } else {
            reqHandler.handle(req);
        }
    }
}

