/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.avro.generic.GenericData;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.avro.AvroBaseRecordTransformer;
import org.apache.cassandra.cdc.avro.CdcEventUtils;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.apache.cassandra.spark.data.CqlField;

public class AvroByteRecordTransformer
extends AvroBaseRecordTransformer<ByteRecordSerializedEvent, byte[]> {
    public AvroByteRecordTransformer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup) {
        this(schemaStore, typeLookup, 838860);
    }

    public AvroByteRecordTransformer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, int truncateThreshold) {
        super(schemaStore, typeLookup, truncateThreshold, "cdc_bytes.avsc");
    }

    @Override
    public ByteRecordSerializedEvent serializeEvent(CdcEvent event) {
        CdcEventUtils.UpdatedEvent updatedEvent = CdcEventUtils.getUpdatedEvent(event, this.store, this.truncateThreshold, this.typeLookup);
        return new ByteRecordSerializedEvent(this.encode(this.store.getWriter(event.keyspace + "." + event.table, null), updatedEvent.getRecord()), updatedEvent.getTruncatedFields());
    }

    @Override
    public GenericData.Record buildRecordWithPayload(ByteRecordSerializedEvent serializedEvent) {
        byte[] payload = (byte[])serializedEvent.payload;
        GenericData.Record record = new GenericData.Record(this.cdcSchema);
        record.put("payload", (Object)ByteBuffer.wrap(payload));
        return record;
    }

    public static class ByteRecordSerializedEvent
    extends AvroBaseRecordTransformer.BaseSerializedEvent<byte[]> {
        private ByteRecordSerializedEvent(byte[] payload, List<String> truncatedFields) {
            super(payload, truncatedFields);
        }
    }
}

