/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcedureHandler
extends NamespaceAwareNestedTagHandler {
    private static final String PROCEDURE_TAG = "procedure";
    private static final String PROCEDURE_PARAMETER_TAG = "procedure-parameter";
    private DataMap map;
    private Procedure procedure;

    public ProcedureHandler(NamespaceAwareNestedTagHandler parentHandler, DataMap map) {
        super(parentHandler);
        this.map = map;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "procedure": {
                this.addProcedure(attributes);
                return true;
            }
            case "procedure-parameter": {
                this.addProcedureParameter(attributes);
                return true;
            }
        }
        return false;
    }

    private void addProcedure(Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        String returningValue = attributes.getValue("returningValue");
        if (null == name) {
            throw new SAXException("ProcedureHandler::addProcedure() - no procedure name.");
        }
        this.procedure = new Procedure(name);
        this.procedure.setReturningValue(returningValue != null && returningValue.equalsIgnoreCase("true"));
        this.procedure.setSchema(attributes.getValue("schema"));
        this.procedure.setCatalog(attributes.getValue("catalog"));
        this.map.addProcedure(this.procedure);
    }

    private void addProcedureParameter(Attributes attributes) throws SAXException {
        String direction;
        String precision;
        String length;
        String name = attributes.getValue("name");
        if (name == null) {
            throw new SAXException("ProcedureHandler::addProcedureParameter() - no procedure parameter name.");
        }
        ProcedureParameter parameter = new ProcedureParameter(name);
        String type = attributes.getValue("type");
        if (type != null) {
            parameter.setType(TypesMapping.getSqlTypeByName(type));
        }
        if ((length = attributes.getValue("length")) != null) {
            parameter.setMaxLength(Integer.parseInt(length));
        }
        if ((precision = attributes.getValue("precision")) != null) {
            parameter.setPrecision(Integer.parseInt(precision));
        }
        if ("in".equals(direction = attributes.getValue("direction"))) {
            parameter.setDirection(1);
        } else if ("out".equals(direction)) {
            parameter.setDirection(2);
        } else if ("in_out".equals(direction)) {
            parameter.setDirection(3);
        }
        this.procedure.addCallParameter(parameter);
    }

    public Procedure getProcedure() {
        return this.procedure;
    }
}

