/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheableQuery
implements Query {
    protected static final Logger logger = LoggerFactory.getLogger(CacheableQuery.class);

    protected abstract BaseQueryMetadata getBaseMetaData();

    public QueryCacheStrategy getCacheStrategy() {
        return this.getBaseMetaData().getCacheStrategy();
    }

    public void setCacheStrategy(QueryCacheStrategy strategy) {
        this.getBaseMetaData().setCacheStrategy(strategy);
    }

    public String getCacheGroup() {
        return this.getBaseMetaData().getCacheGroup();
    }

    public void setCacheGroup(String cacheGroup) {
        this.getBaseMetaData().setCacheGroup(cacheGroup);
    }

    public void useLocalCache() {
        this.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
    }

    public void useLocalCache(String cacheGroup) {
        this.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        this.setCacheGroup(cacheGroup);
    }

    public void useSharedCache() {
        this.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
    }

    public void useSharedCache(String cacheGroup) {
        this.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        this.setCacheGroup(cacheGroup);
    }
}

