/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ArchiveStreamFactoryTest
extends AbstractTest {
    private static final String UNKNOWN = "??";
    private static final ArchiveStreamFactory FACTORY;
    private static final ArchiveStreamFactory FACTORY_UTF8;
    private static final ArchiveStreamFactory FACTORY_ASCII;
    private static final ArchiveStreamFactory FACTORY_SET_UTF8;
    private static final ArchiveStreamFactory FACTORY_SET_ASCII;
    private static final String ARJ_DEFAULT;
    private static final String DUMP_DEFAULT;
    private static final String ZIP_DEFAULT;
    private static final String CPIO_DEFAULT;
    private static final String TAR_DEFAULT;
    private static final String JAR_DEFAULT;
    static final TestData[] TESTS;

    ArchiveStreamFactoryTest() {
    }

    private static String getCharsetName(ArchiveInputStream<?> inputStream) {
        return inputStream.getCharset().name();
    }

    static ArchiveStreamFactory getFactory(String entryEncoding) {
        ArchiveStreamFactory fac = new ArchiveStreamFactory();
        fac.setEntryEncoding(entryEncoding);
        return fac;
    }

    private static String getFieldAsString(Object instance, String name) {
        if (instance instanceof ArchiveInputStream) {
            return ArchiveStreamFactoryTest.getCharsetName((ArchiveInputStream)instance);
        }
        try {
            Object object = FieldUtils.readField((Object)instance, (String)name, (boolean)true);
            if (object == null) {
                return null;
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof Charset) {
                return ((Charset)object).name();
            }
            return object.toString();
        }
        catch (IllegalAccessException e) {
            System.out.println("Cannot find " + name + " in class " + instance.getClass().getSimpleName());
            return UNKNOWN;
        }
    }

    public static Stream<Path> getIcoPathStream() throws IOException {
        return Files.walk(Paths.get("src/test/resources/org/apache/commons/compress/ico", new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    private String detect(String resource) throws IOException, ArchiveException {
        try (BufferedInputStream in = new BufferedInputStream(ArchiveStreamFactoryTest.newInputStream(resource));){
            String string = ArchiveStreamFactory.detect((InputStream)in);
            return string;
        }
    }

    private <T extends ArchiveInputStream<? extends E>, E extends ArchiveEntry> T getInputStream(String resource, ArchiveStreamFactory factory) throws IOException, ArchiveException {
        return (T)factory.createArchiveInputStream((InputStream)new BufferedInputStream(ArchiveStreamFactoryTest.newInputStream(resource)));
    }

    private <T extends ArchiveInputStream<? extends E>, E extends ArchiveEntry> T getInputStream(String type, String resource, ArchiveStreamFactory factory) throws IOException, ArchiveException {
        return (T)factory.createArchiveInputStream(type, (InputStream)new BufferedInputStream(ArchiveStreamFactoryTest.newInputStream(resource)));
    }

    private <T extends ArchiveOutputStream<? extends E>, E extends ArchiveEntry> T getOutputStream(String type, ArchiveStreamFactory factory) throws ArchiveException {
        return (T)factory.createArchiveOutputStream(type, (OutputStream)new ByteArrayOutputStream());
    }

    @Test
    void testAiffFilesAreNoTARs() throws Exception {
        try (InputStream fis = ArchiveStreamFactoryTest.newInputStream("testAIFF.aif");
             BufferedInputStream is = new BufferedInputStream(fis);){
            ArchiveException ae = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveInputStream(is), (String)"created an input stream for a non-archive");
            Assertions.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
        }
    }

    @Test
    void testCantRead7zFromStream() throws Exception {
        Assertions.assertThrows(StreamingNotSupportedException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveInputStream("7z", (InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY)));
    }

    @Test
    void testCantWrite7zToStream() throws Exception {
        Assertions.assertThrows(StreamingNotSupportedException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("7z", (OutputStream)new ByteArrayOutputStream()));
    }

    @Test
    void testCOMPRESS209() throws Exception {
        try (InputStream fis = ArchiveStreamFactoryTest.newInputStream("testCompress209.doc");
             BufferedInputStream bis = new BufferedInputStream(fis);){
            ArchiveException ae = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveInputStream(bis), (String)"created an input stream for a non-archive");
            Assertions.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
        }
    }

    @Test
    void testDetect() throws Exception {
        for (String extension : new String[]{"ar", "arj", "cpio", "dump", "7z", "tar", "zip"}) {
            Assertions.assertEquals((Object)extension, (Object)this.detect("bla." + extension));
        }
        ArchiveException e1 = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> ArchiveStreamFactory.detect((InputStream)new BufferedInputStream(new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY))), (String)"shouldn't be able to detect empty stream");
        Assertions.assertEquals((Object)"No Archiver found for the stream signature", (Object)e1.getMessage());
        IllegalArgumentException e2 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveStreamFactory.detect(null), (String)"shouldn't be able to detect null stream");
        Assertions.assertEquals((Object)"Stream must not be null.", (Object)e2.getMessage());
        ArchiveException e3 = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> ArchiveStreamFactory.detect((InputStream)new BufferedInputStream((InputStream)new BrokenInputStream())), (String)"Expected ArchiveException");
        Assertions.assertEquals((Object)"Failure reading signature.", (Object)e3.getMessage());
    }

    @Test
    void testDetectsAndThrowsFor7z() throws Exception {
        try (InputStream fis = ArchiveStreamFactoryTest.newInputStream("bla.7z");
             BufferedInputStream bis = new BufferedInputStream(fis);){
            StreamingNotSupportedException ex = (StreamingNotSupportedException)Assertions.assertThrows(StreamingNotSupportedException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveInputStream(bis), (String)"Expected a StreamingNotSupportedException");
            Assertions.assertEquals((Object)"7z", (Object)ex.getFormat());
        }
    }

    @Test
    void testEncodingCtor() {
        ArchiveStreamFactory fac = new ArchiveStreamFactory();
        Assertions.assertNull((Object)fac.getEntryEncoding());
        fac = new ArchiveStreamFactory(null);
        Assertions.assertNull((Object)fac.getEntryEncoding());
        fac = new ArchiveStreamFactory(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)fac.getEntryEncoding());
    }

    @Test
    void testEncodingDeprecated() {
        ArchiveStreamFactory fac1 = new ArchiveStreamFactory();
        Assertions.assertNull((Object)fac1.getEntryEncoding());
        fac1.setEntryEncoding(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)fac1.getEntryEncoding());
        fac1.setEntryEncoding(StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII.name(), (Object)fac1.getEntryEncoding());
        ArchiveStreamFactory fac2 = new ArchiveStreamFactory(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)fac2.getEntryEncoding());
        fac2.setEntryEncoding(StandardCharsets.US_ASCII.name());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII.name(), (Object)fac2.getEntryEncoding());
    }

    @Test
    void testEncodingInputStream() throws Exception {
        int failed = 0;
        for (int i = 1; i <= TESTS.length; ++i) {
            TestData test = TESTS[i - 1];
            try (Object ais = this.getInputStream(test.type, test.testFile, test.fac);){
                String field = ArchiveStreamFactoryTest.getCharsetName(ais);
                if (Objects.equals(field, field)) continue;
                System.err.println("Failed test " + i + ". expected: " + test.expectedEncoding + " actual: " + field + " type: " + test.type);
                ++failed;
                continue;
            }
        }
        if (failed > 0) {
            Assertions.fail((String)("Tests failed: " + failed + " out of " + TESTS.length));
        }
    }

    @Test
    void testEncodingInputStreamAutodetect() throws Exception {
        int failed = 0;
        for (int i = 1; i <= TESTS.length; ++i) {
            TestData test = TESTS[i - 1];
            try (Object ais = this.getInputStream(test.testFile, test.fac);){
                String field = ArchiveStreamFactoryTest.getCharsetName(ais);
                if (Objects.equals(field, field)) continue;
                System.err.println("Failed test " + i + ". expected: " + test.expectedEncoding + " actual: " + field + " type: " + test.type);
                ++failed;
                continue;
            }
        }
        if (failed > 0) {
            Assertions.fail((String)("Tests failed: " + failed + " out of " + TESTS.length));
        }
    }

    @Test
    void testEncodingOutputStream() throws Exception {
        int failed = 0;
        for (int i = 1; i <= TESTS.length; ++i) {
            TestData test = TESTS[i - 1];
            if (!test.hasOutputStream) continue;
            try (Object ais = this.getOutputStream(test.type, test.fac);){
                String field = ArchiveStreamFactoryTest.getFieldAsString(ais, test.fieldName);
                if (Objects.equals(field, field)) continue;
                System.err.println("Failed test " + i + ". expected: " + test.expectedEncoding + " actual: " + field + " type: " + test.type);
                ++failed;
                continue;
            }
        }
        if (failed > 0) {
            Assertions.fail((String)("Tests failed: " + failed + " out of " + TESTS.length));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getIcoPathStream"})
    void testIcoFilesAreNoTARs(Path path) throws Exception {
        ArchiveException ae;
        BufferedInputStream is;
        try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
            is = new BufferedInputStream(fis);
            try {
                ae = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> ArchiveStreamFactory.detect((InputStream)is), (String)"created an input stream for a non-archive");
                Assertions.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
            }
            finally {
                ((InputStream)is).close();
            }
        }
        fis = Files.newInputStream(path, new OpenOption[0]);
        try {
            is = new BufferedInputStream(fis);
            try {
                ae = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveInputStream(is), (String)"created an input stream for a non-archive");
                Assertions.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
            }
            finally {
                ((InputStream)is).close();
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    @Test
    void testShortTextFilesAreNoTARs() {
        ArchiveException ae = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveInputStream((InputStream)new ByteArrayInputStream("This certainly is not a tar archive, really, no kidding".getBytes())), (String)"created an input stream for a non-archive");
        Assertions.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
    }

    @Test
    void testSkipsPK00Prefix() throws Exception {
        try (InputStream fis = ArchiveStreamFactoryTest.newInputStream("COMPRESS-208.zip");
             BufferedInputStream bis = new BufferedInputStream(fis);
             ArchiveInputStream ais = ArchiveStreamFactory.DEFAULT.createArchiveInputStream((InputStream)bis);){
            Assertions.assertInstanceOf(ZipArchiveInputStream.class, (Object)ais);
        }
    }

    @Test
    void testTarContainingDirWith1TxtFileIsTAR() throws IOException, ArchiveException {
        Assertions.assertEquals((Object)"tar", (Object)this.detect("dirWith1TxtFile.tar"));
    }

    @Test
    void testTarContainingEmptyDirIsTAR() throws IOException, ArchiveException {
        Assertions.assertEquals((Object)"tar", (Object)this.detect("emptyDir.tar"));
    }

    @Test
    void testUtf16TextIsNotTAR() {
        ArchiveException archiveException = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> this.detect("utf16-text.txt"));
        Assertions.assertEquals((Object)"No Archiver found for the stream signature", (Object)archiveException.getMessage());
    }

    static {
        ArjArchiveInputStream inputStream;
        FACTORY = ArchiveStreamFactory.DEFAULT;
        FACTORY_UTF8 = new ArchiveStreamFactory(StandardCharsets.UTF_8.name());
        FACTORY_ASCII = new ArchiveStreamFactory(StandardCharsets.US_ASCII.name());
        FACTORY_SET_UTF8 = ArchiveStreamFactoryTest.getFactory(StandardCharsets.UTF_8.name());
        FACTORY_SET_ASCII = ArchiveStreamFactoryTest.getFactory(StandardCharsets.US_ASCII.name());
        ZIP_DEFAULT = ArchiveStreamFactoryTest.getCharsetName(new ZipArchiveInputStream(null));
        CPIO_DEFAULT = ArchiveStreamFactoryTest.getCharsetName(new CpioArchiveInputStream(null));
        TAR_DEFAULT = ArchiveStreamFactoryTest.getCharsetName(new TarArchiveInputStream(null));
        JAR_DEFAULT = ArchiveStreamFactoryTest.getCharsetName(new JarArchiveInputStream(null));
        String dflt = UNKNOWN;
        try {
            inputStream = new ArjArchiveInputStream(ArchiveStreamFactoryTest.newInputStream("bla.arj"));
            try {
                dflt = ArchiveStreamFactoryTest.getCharsetName(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ARJ_DEFAULT = dflt;
        dflt = UNKNOWN;
        try {
            inputStream = new DumpArchiveInputStream(ArchiveStreamFactoryTest.newInputStream("bla.dump"));
            try {
                dflt = ArchiveStreamFactoryTest.getCharsetName(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DUMP_DEFAULT = dflt;
        TESTS = new TestData[]{new TestData("bla.arj", "arj", false, ARJ_DEFAULT, FACTORY, "charsetName"), new TestData("bla.arj", "arj", false, StandardCharsets.UTF_8.name(), FACTORY_UTF8, "charsetName"), new TestData("bla.arj", "arj", false, StandardCharsets.US_ASCII.name(), FACTORY_ASCII, "charsetName"), new TestData("bla.arj", "arj", false, StandardCharsets.UTF_8.name(), FACTORY_SET_UTF8, "charsetName"), new TestData("bla.arj", "arj", false, StandardCharsets.US_ASCII.name(), FACTORY_SET_ASCII, "charsetName"), new TestData("bla.cpio", "cpio", true, CPIO_DEFAULT, FACTORY, "charsetName"), new TestData("bla.cpio", "cpio", true, StandardCharsets.UTF_8.name(), FACTORY_UTF8, "charsetName"), new TestData("bla.cpio", "cpio", true, StandardCharsets.US_ASCII.name(), FACTORY_ASCII, "charsetName"), new TestData("bla.cpio", "cpio", true, StandardCharsets.UTF_8.name(), FACTORY_SET_UTF8, "charsetName"), new TestData("bla.cpio", "cpio", true, StandardCharsets.US_ASCII.name(), FACTORY_SET_ASCII, "charsetName"), new TestData("bla.dump", "dump", false, DUMP_DEFAULT, FACTORY, "charsetName"), new TestData("bla.dump", "dump", false, StandardCharsets.UTF_8.name(), FACTORY_UTF8, "charsetName"), new TestData("bla.dump", "dump", false, StandardCharsets.US_ASCII.name(), FACTORY_ASCII, "charsetName"), new TestData("bla.dump", "dump", false, StandardCharsets.UTF_8.name(), FACTORY_SET_UTF8, "charsetName"), new TestData("bla.dump", "dump", false, StandardCharsets.US_ASCII.name(), FACTORY_SET_ASCII, "charsetName"), new TestData("bla.tar", "tar", true, TAR_DEFAULT, FACTORY, "charsetName"), new TestData("bla.tar", "tar", true, StandardCharsets.UTF_8.name(), FACTORY_UTF8, "charsetName"), new TestData("bla.tar", "tar", true, StandardCharsets.US_ASCII.name(), FACTORY_ASCII, "charsetName"), new TestData("bla.tar", "tar", true, StandardCharsets.UTF_8.name(), FACTORY_SET_UTF8, "charsetName"), new TestData("bla.tar", "tar", true, StandardCharsets.US_ASCII.name(), FACTORY_SET_ASCII, "charsetName"), new TestData("bla.jar", "jar", true, JAR_DEFAULT, FACTORY, "charset"), new TestData("bla.jar", "jar", true, StandardCharsets.UTF_8.name(), FACTORY_UTF8, "charset"), new TestData("bla.jar", "jar", true, StandardCharsets.US_ASCII.name(), FACTORY_ASCII, "charset"), new TestData("bla.jar", "jar", true, StandardCharsets.UTF_8.name(), FACTORY_SET_UTF8, "charset"), new TestData("bla.jar", "jar", true, StandardCharsets.US_ASCII.name(), FACTORY_SET_ASCII, "charset"), new TestData("bla.zip", "zip", true, ZIP_DEFAULT, FACTORY, "charset"), new TestData("bla.zip", "zip", true, StandardCharsets.UTF_8.name(), FACTORY_UTF8, "charset"), new TestData("bla.zip", "zip", true, StandardCharsets.US_ASCII.name(), FACTORY_ASCII, "charset"), new TestData("bla.zip", "zip", true, StandardCharsets.UTF_8.name(), FACTORY_SET_UTF8, "charset"), new TestData("bla.zip", "zip", true, StandardCharsets.US_ASCII.name(), FACTORY_SET_ASCII, "charset")};
    }

    static class TestData {
        final String testFile;
        final String expectedEncoding;
        final ArchiveStreamFactory fac;
        final String fieldName;
        final String type;
        final boolean hasOutputStream;

        TestData(String testFile, String type, boolean hasOut, String expectedEncoding, ArchiveStreamFactory fac, String fieldName) {
            this.testFile = testFile;
            this.expectedEncoding = expectedEncoding;
            this.fac = fac;
            this.fieldName = fieldName;
            this.type = type;
            this.hasOutputStream = hasOut;
        }

        public String toString() {
            return "TestData [testFile=" + this.testFile + ", expectedEncoding=" + this.expectedEncoding + ", fac=" + this.fac + ", fieldName=" + this.fieldName + ", type=" + this.type + ", hasOutputStream=" + this.hasOutputStream + "]";
        }
    }
}

