/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp2.AbandonedTrace;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.dbcp2.SQLExceptionList;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterResultSet;
import org.apache.commons.dbcp2.TesterStatement;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDelegatingStatement {
    private DelegatingConnection<Connection> delegatingConnection;
    private TesterConnection testerConnection;
    private Statement mockedStatement;
    private DelegatingStatement delegatingStatement;
    private DelegatingStatement delegatingTesterStatement;
    private TesterResultSet testerResultSet;
    private TesterStatement testerStatement;

    @AfterEach
    public void afterEach() {
        this.testerResultSet.setSqlExceptionOnClose(false);
        this.testerStatement.setSqlExceptionOnClose(false);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testerConnection = new TesterConnection("test", "test");
        this.delegatingConnection = new DelegatingConnection((Connection)this.testerConnection);
        this.mockedStatement = (Statement)Mockito.mock(Statement.class);
        this.testerStatement = new TesterStatement(this.testerConnection);
        this.delegatingStatement = new DelegatingStatement(this.delegatingConnection, this.mockedStatement);
        this.delegatingTesterStatement = new DelegatingStatement(this.delegatingConnection, (Statement)this.testerStatement);
        this.testerResultSet = new TesterResultSet(this.mockedStatement);
    }

    @Test
    void testAddBatchString() throws Exception {
        try {
            this.delegatingStatement.addBatch("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).addBatch("foo");
    }

    @Test
    void testCancel() throws Exception {
        try {
            this.delegatingStatement.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).cancel();
    }

    @Test
    void testCheckOpen() throws Exception {
        this.delegatingStatement.checkOpen();
        this.delegatingStatement.close();
        Assertions.assertThrows(SQLException.class, () -> ((DelegatingStatement)this.delegatingStatement).checkOpen());
    }

    @Test
    void testClearBatch() throws Exception {
        try {
            this.delegatingStatement.clearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).clearBatch();
    }

    @Test
    void testClearWarnings() throws Exception {
        try {
            this.delegatingStatement.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).clearWarnings();
    }

    @Test
    void testClose() throws Exception {
        try {
            this.delegatingStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    void testCloseOnCompletion() throws Exception {
        try {
            this.delegatingStatement.closeOnCompletion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).closeOnCompletion();
    }

    @Test
    void testCloseWithResultSetCloseException() throws Exception {
        this.testerResultSet.setSqlExceptionOnClose(true);
        this.delegatingStatement.addTrace((AbandonedTrace)this.testerResultSet);
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> ((DelegatingStatement)this.delegatingStatement).close());
        Assertions.assertInstanceOf(SQLExceptionList.class, (Object)e);
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    void testCloseWithStatementCloseException() throws Exception {
        this.testerStatement.setSqlExceptionOnClose(true);
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> ((DelegatingStatement)this.delegatingTesterStatement).close());
        Assertions.assertInstanceOf(SQLExceptionList.class, (Object)e);
    }

    @Test
    void testExecuteBatch() throws Exception {
        try {
            this.delegatingStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeBatch();
    }

    @Test
    void testExecuteLargeBatch() throws Exception {
        try {
            this.delegatingStatement.executeLargeBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
    }

    @Test
    void testExecuteLargeUpdateString() throws Exception {
        try {
            this.delegatingStatement.executeLargeUpdate("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate("foo");
    }

    @Test
    void testExecuteLargeUpdateStringInteger() throws Exception {
        try {
            this.delegatingStatement.executeLargeUpdate("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate("foo", 1);
    }

    @Test
    void testExecuteLargeUpdateStringIntegerArray() throws Exception {
        try {
            this.delegatingStatement.executeLargeUpdate("foo", (int[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate("foo", (int[])null);
    }

    @Test
    void testExecuteLargeUpdateStringStringArray() throws Exception {
        try {
            this.delegatingStatement.executeLargeUpdate("foo", (String[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate("foo", (String[])null);
    }

    @Test
    void testExecuteQueryReturnsNull() throws Exception {
        Assertions.assertNull((Object)this.delegatingStatement.executeQuery("null"));
    }

    @Test
    void testExecuteQueryString() throws Exception {
        try {
            this.delegatingStatement.executeQuery("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery("foo");
    }

    @Test
    void testExecuteString() throws Exception {
        try {
            this.delegatingStatement.execute("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).execute("foo");
    }

    @Test
    void testExecuteStringInteger() throws Exception {
        try {
            this.delegatingStatement.execute("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).execute("foo", 1);
    }

    @Test
    void testExecuteStringIntegerArray() throws Exception {
        try {
            this.delegatingStatement.execute("foo", (int[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).execute("foo", (int[])null);
    }

    @Test
    void testExecuteStringStringArray() throws Exception {
        try {
            this.delegatingStatement.execute("foo", (String[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).execute("foo", (String[])null);
    }

    @Test
    void testExecuteUpdateString() throws Exception {
        try {
            this.delegatingStatement.executeUpdate("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeUpdate("foo");
    }

    @Test
    void testExecuteUpdateStringInteger() throws Exception {
        try {
            this.delegatingStatement.executeUpdate("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeUpdate("foo", 1);
    }

    @Test
    void testExecuteUpdateStringIntegerArray() throws Exception {
        try {
            this.delegatingStatement.executeUpdate("foo", (int[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeUpdate("foo", (int[])null);
    }

    @Test
    void testExecuteUpdateStringStringArray() throws Exception {
        try {
            this.delegatingStatement.executeUpdate("foo", (String[])null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).executeUpdate("foo", (String[])null);
    }

    @Test
    void testGetConnection() throws Exception {
        try {
            this.delegatingStatement.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)0))).getConnection();
    }

    @Test
    void testGetDelegate() throws Exception {
        Assertions.assertEquals((Object)this.mockedStatement, (Object)this.delegatingStatement.getDelegate());
    }

    @Test
    void testGetFetchDirection() throws Exception {
        try {
            this.delegatingStatement.getFetchDirection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getFetchDirection();
    }

    @Test
    void testGetFetchSize() throws Exception {
        try {
            this.delegatingStatement.getFetchSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getFetchSize();
    }

    @Test
    void testGetGeneratedKeys() throws Exception {
        try {
            this.delegatingStatement.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getGeneratedKeys();
    }

    @Test
    void testGetLargeMaxRows() throws Exception {
        try {
            this.delegatingStatement.getLargeMaxRows();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getLargeMaxRows();
    }

    @Test
    void testGetLargeUpdateCount() throws Exception {
        try {
            this.delegatingStatement.getLargeUpdateCount();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getLargeUpdateCount();
    }

    @Test
    void testGetMaxFieldSize() throws Exception {
        try {
            this.delegatingStatement.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getMaxFieldSize();
    }

    @Test
    void testGetMaxRows() throws Exception {
        try {
            this.delegatingStatement.getMaxRows();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getMaxRows();
    }

    @Test
    void testGetMoreResults() throws Exception {
        try {
            this.delegatingStatement.getMoreResults();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getMoreResults();
    }

    @Test
    void testGetMoreResultsInteger() throws Exception {
        try {
            this.delegatingStatement.getMoreResults(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getMoreResults(1);
    }

    @Test
    void testGetQueryTimeout() throws Exception {
        try {
            this.delegatingStatement.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getQueryTimeout();
    }

    @Test
    void testGetResultSet() throws Exception {
        try {
            this.delegatingStatement.getResultSet();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getResultSet();
    }

    @Test
    void testGetResultSetConcurrency() throws Exception {
        try {
            this.delegatingStatement.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getResultSetConcurrency();
    }

    @Test
    void testGetResultSetHoldability() throws Exception {
        try {
            this.delegatingStatement.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getResultSetHoldability();
    }

    @Test
    void testGetResultSetType() throws Exception {
        try {
            this.delegatingStatement.getResultSetType();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getResultSetType();
    }

    @Test
    void testGetUpdateCount() throws Exception {
        try {
            this.delegatingStatement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getUpdateCount();
    }

    @Test
    void testGetWarnings() throws Exception {
        try {
            this.delegatingStatement.getWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).getWarnings();
    }

    @Test
    void testIsClosed() throws Exception {
        try {
            this.delegatingStatement.isClosed();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)0))).isClosed();
    }

    @Test
    void testIsCloseOnCompletion() throws Exception {
        try {
            this.delegatingStatement.isCloseOnCompletion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).isCloseOnCompletion();
    }

    @Test
    void testIsPoolable() throws Exception {
        try {
            this.delegatingStatement.isPoolable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).isPoolable();
    }

    @Test
    void testIsWrapperFor() throws Exception {
        TesterConnection tstConn = new TesterConnection("test", "test");
        TesterStatementNonWrapping tstStmt = new TesterStatementNonWrapping(tstConn);
        DelegatingConnection dconn = new DelegatingConnection((Connection)tstConn);
        DelegatingStatement stamt = new DelegatingStatement(dconn, (Statement)tstStmt);
        Class<?> stmtProxyClass = Proxy.getProxyClass(this.getClass().getClassLoader(), Statement.class);
        Assertions.assertTrue((boolean)stamt.isWrapperFor(DelegatingStatement.class));
        Assertions.assertTrue((boolean)stamt.isWrapperFor(TesterStatement.class));
        Assertions.assertFalse((boolean)stamt.isWrapperFor(stmtProxyClass));
        stamt.close();
    }

    @Test
    void testSetCursorNameString() throws Exception {
        try {
            this.delegatingStatement.setCursorName("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).setCursorName("foo");
    }

    @Test
    void testSetEscapeProcessingBoolean() throws Exception {
        try {
            this.delegatingStatement.setEscapeProcessing(Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).setEscapeProcessing(Boolean.TRUE);
    }

    @Test
    void testSetFetchDirectionInteger() throws Exception {
        try {
            this.delegatingStatement.setFetchDirection(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).setFetchDirection(1);
    }

    @Test
    void testSetFetchSizeInteger() throws Exception {
        try {
            this.delegatingStatement.setFetchSize(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).setFetchSize(1);
    }

    @Test
    void testSetLargeMaxRowsLong() throws Exception {
        try {
            this.delegatingStatement.setLargeMaxRows(1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).setLargeMaxRows(1L);
    }

    @Test
    void testSetMaxFieldSizeInteger() throws Exception {
        try {
            this.delegatingStatement.setMaxFieldSize(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).setMaxFieldSize(1);
    }

    @Test
    void testSetMaxRowsInteger() throws Exception {
        try {
            this.delegatingStatement.setMaxRows(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).setMaxRows(1);
    }

    @Test
    void testSetPoolableBoolean() throws Exception {
        try {
            this.delegatingStatement.setPoolable(Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).setPoolable(Boolean.TRUE);
    }

    @Test
    void testSetQueryTimeoutInteger() throws Exception {
        try {
            this.delegatingStatement.setQueryTimeout(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((Statement)Mockito.verify((Object)this.mockedStatement, (VerificationMode)Mockito.times((int)1))).setQueryTimeout(1);
    }

    @Test
    void testWrap() throws SQLException {
        Assertions.assertEquals((Object)this.delegatingStatement, (Object)this.delegatingStatement.unwrap(Statement.class));
        Assertions.assertEquals((Object)this.delegatingStatement, (Object)this.delegatingStatement.unwrap(DelegatingStatement.class));
        Assertions.assertEquals((Object)this.mockedStatement, (Object)this.delegatingStatement.unwrap(this.mockedStatement.getClass()));
        Assertions.assertNull((Object)this.delegatingStatement.unwrap(String.class));
        Assertions.assertTrue((boolean)this.delegatingStatement.isWrapperFor(Statement.class));
        Assertions.assertTrue((boolean)this.delegatingStatement.isWrapperFor(DelegatingStatement.class));
        Assertions.assertTrue((boolean)this.delegatingStatement.isWrapperFor(this.mockedStatement.getClass()));
        Assertions.assertFalse((boolean)this.delegatingStatement.isWrapperFor(String.class));
    }

    private static final class TesterStatementNonWrapping
    extends TesterStatement {
        public TesterStatementNonWrapping(Connection conn) {
            super(conn);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

