/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.transaction;

import java.util.Map;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionDetail;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;

public class JMSTransactionDetail
extends TransactionDetail {
    public JMSTransactionDetail(Xid xid, Transaction tx, Long creation) {
        super(xid, tx, creation);
    }

    public String decodeMessageType(Message msg) {
        if (!(msg instanceof ICoreMessage)) {
            return "N/A";
        }
        ICoreMessage coreMessage = (ICoreMessage)msg;
        return switch (coreMessage.getType()) {
            case 0 -> "Default";
            case 2 -> "ObjectMessage";
            case 3 -> "TextMessage";
            case 4 -> "ByteMessage";
            case 5 -> "MapMessage";
            case 6 -> "StreamMessage";
            default -> "(Unknown Type)";
        };
    }

    public Map<String, Object> decodeMessageProperties(Message msg) {
        try {
            return ActiveMQMessage.coreMaptoJMSMap((Map)msg.toMap());
        }
        catch (Throwable t) {
            return null;
        }
    }
}

