/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.constraint;

import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="SRCOM", length=5)
interface Messages {
    public static final Messages log = (Messages)org.jboss.logging.Messages.getBundle(Messages.class);

    @Message(id=0, value="Parameter '%s' may not be null")
    public IllegalArgumentException nullParam(String var1);

    @Message(id=1, value="Parameter '%s' may not be less than %s")
    public IllegalArgumentException paramLessThan(String var1, long var2);

    public IllegalArgumentException paramLessThan(String var1, double var2);

    public IllegalArgumentException paramLessThan(String var1, Object var2);

    @Message(id=2, value="Parameter '%s' may not be greater than than %s")
    public IllegalArgumentException paramGreaterThan(String var1, long var2);

    public IllegalArgumentException paramGreaterThan(String var1, double var2);

    public IllegalArgumentException paramGreaterThan(String var1, Object var2);

    @Message(id=3, value="Given offset of %d is greater than array length of %d")
    public ArrayIndexOutOfBoundsException arrayOffsetGreaterThanLength(int var1, int var2);

    @Message(id=4, value="Given offset of %d plus length of %d is greater than array length of %d")
    public ArrayIndexOutOfBoundsException arrayOffsetLengthGreaterThanLength(int var1, int var2, int var3);

    @Message(id=5, value="Array index %d of parameter '%s' may not be null")
    public IllegalArgumentException nullArrayParam(int var1, String var2);

    @Message(id=6, value="Parameter '%s' must not be empty")
    public IllegalArgumentException emptyParam(String var1);

    @Message(id=7, value="Internal error: Assertion failure: Unexpectedly null value")
    public String unexpectedNullValue();

    @Message(id=8, value="Internal error: Assertion failure: Current thread expected to hold lock for %s")
    public String expectedLockHold(Object var1);

    @Message(id=9, value="Internal error: Assertion failure: Current thread expected to not hold lock for %s")
    public String expectedLockNotHold(Object var1);

    @Message(id=10, value="Internal error: Assertion failure: Expected boolean value to be %s")
    public String expectedBoolean(boolean var1);

    @Message(id=11, value="Internal error: Unreachable code has been reached")
    public IllegalStateException unreachableCode();

    @Message(id=12, value="Internal error: Impossible switch condition encountered: %s")
    public IllegalStateException impossibleSwitchCase(Object var1);

    @Message(id=13, value="Method \"%s\" of class \"%s\" is not supported")
    public UnsupportedOperationException unsupported(String var1, String var2);

    @Message(id=14, value="Parameter '%s' must be a power of two")
    public IllegalArgumentException paramNotPow2(String var1);
}

