/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.io;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import org.apache.druid.java.util.common.logger.Logger;

public class NativeIO {
    private static final Logger log = new Logger(NativeIO.class);
    private static final int POSIX_FADV_DONTNEED = 4;
    private static final int SYNC_FILE_RANGE_WAIT_BEFORE = 1;
    private static final int SYNC_FILE_RANGE_WRITE = 2;
    private static final int SYNC_FILE_RANGE_WAIT_AFTER = 4;
    private static Field field;
    private static volatile boolean initialized;
    private static volatile boolean fadvisePossible;
    private static volatile boolean syncFileRangePossible;

    private static native int posix_fadvise(int var0, long var1, long var3, int var5) throws LastErrorException;

    private static native int sync_file_range(int var0, long var1, long var3, int var5);

    private NativeIO() {
    }

    private static Field getFieldByReflection(Class cls, String fieldName) {
        Field field = null;
        try {
            field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (Exception e) {
            log.warn("Unable to read [%s] field from [%s]", fieldName, cls.getName());
        }
        return field;
    }

    public static int getfd(FileDescriptor descriptor) {
        try {
            return field.getInt(descriptor);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.warn("Unable to read fd field from java.io.FileDescriptor", new Object[0]);
            return -1;
        }
    }

    public static void trySkipCache(int fd, long offset, long len) {
        if (!initialized || !fadvisePossible || fd < 0) {
            return;
        }
        try {
            NativeIO.posix_fadvise(fd, offset, len, 4);
        }
        catch (UnsupportedOperationException uoe) {
            log.warn(uoe, "posix_fadvise is not supported", new Object[0]);
            fadvisePossible = false;
        }
        catch (UnsatisfiedLinkError ule) {
            log.warn(ule, "Unsatisfied Link error: posix_fadvise failed on file descriptor [%d], offset [%d]", fd, offset);
            fadvisePossible = false;
        }
        catch (Exception e) {
            log.warn(e, "Unknown exception: posix_fadvise failed on file descriptor [%d], offset [%d]", fd, offset);
        }
    }

    private static void trySyncFileRange(int fd, long offset, long nbytes, int flags) {
        if (!initialized || !syncFileRangePossible || fd < 0) {
            return;
        }
        try {
            int ret_code = NativeIO.sync_file_range(fd, offset, nbytes, flags);
            if (ret_code != 0) {
                log.warn("failed on syncing fd [%d], offset [%d], bytes [%d], ret_code [%d], errno [%d]", fd, offset, nbytes, ret_code, Native.getLastError());
                return;
            }
        }
        catch (UnsupportedOperationException uoe) {
            log.warn(uoe, "sync_file_range is not supported", new Object[0]);
            syncFileRangePossible = false;
        }
        catch (UnsatisfiedLinkError nle) {
            log.warn(nle, "sync_file_range failed on fd [%d], offset [%d], bytes [%d]", fd, offset, nbytes);
            syncFileRangePossible = false;
        }
        catch (Exception e) {
            log.warn(e, "Unknown exception: sync_file_range failed on fd [%d], offset [%d], bytes [%d]", fd, offset, nbytes);
            syncFileRangePossible = false;
        }
    }

    public static void chunkedCopy(InputStream src, File dest) throws IOException {
        byte[] buf = new byte[0x800000];
        long offset = 0L;
        long lastOffset = 0L;
        try (RandomAccessFile raf = new RandomAccessFile(dest, "rw");){
            int fd = NativeIO.getfd(raf.getFD());
            int numBytes = 0;
            int bytesRead = 0;
            int lastBytes = 0;
            while (bytesRead > -1) {
                bytesRead = src.read(buf, numBytes, buf.length - numBytes);
                if (numBytes >= buf.length || bytesRead == -1) {
                    raf.write(buf, 0, numBytes);
                    NativeIO.trySyncFileRange(fd, offset, numBytes, 2);
                    if (offset > 0L) {
                        NativeIO.trySyncFileRange(fd, lastOffset, lastBytes, 7);
                        NativeIO.trySkipCache(fd, lastOffset, lastBytes);
                    }
                    lastOffset = offset;
                    offset = raf.getFilePointer();
                    numBytes = 0;
                }
                lastBytes = numBytes;
                numBytes += bytesRead;
            }
        }
    }

    @VisibleForTesting
    static void setFadvisePossible(boolean setting) {
        fadvisePossible = setting;
    }

    @VisibleForTesting
    static boolean isFadvisePossible() {
        return fadvisePossible;
    }

    @VisibleForTesting
    static void setSyncFileRangePossible(boolean setting) {
        syncFileRangePossible = setting;
    }

    @VisibleForTesting
    static boolean isSyncFileRangePossible() {
        return syncFileRangePossible;
    }

    static {
        initialized = false;
        fadvisePossible = true;
        syncFileRangePossible = true;
        field = NativeIO.getFieldByReflection(FileDescriptor.class, "fd");
        try {
            Native.register((String)Platform.C_LIBRARY_NAME);
            initialized = true;
        }
        catch (NoClassDefFoundError e) {
            log.info("JNA not found. Native methods will be disabled.", new Object[0]);
        }
        catch (UnsatisfiedLinkError e) {
            log.info("Unable to link C library. Native methods will be disabled.", new Object[0]);
        }
        catch (NoSuchMethodError e) {
            log.warn("Obsolete version of JNA present; unable to register C library", new Object[0]);
        }
    }
}

