/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.Comparator;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ValueType;

public class DimensionComparisonUtils {
    public static boolean isNaturalComparator(ValueType type, StringComparator comparator) {
        if (StringComparators.NATURAL.equals(comparator)) {
            return true;
        }
        return (type == ValueType.STRING && StringComparators.LEXICOGRAPHIC.equals(comparator) || type.isNumeric() && StringComparators.NUMERIC.equals(comparator)) && !type.isArray();
    }

    public static class ArrayComparatorForUnnaturalStringComparator
    extends ArrayComparator<String> {
        public ArrayComparatorForUnnaturalStringComparator(StringComparator elementComparator) {
            super(elementComparator);
        }

        @Override
        protected String coerceElement(Object element) {
            return String.valueOf(element);
        }
    }

    public static class ArrayComparator<T>
    implements Comparator<Object[]> {
        private final Comparator<T> elementComparator;

        public ArrayComparator(Comparator<T> elementComparator) {
            this.elementComparator = elementComparator;
        }

        @Override
        public int compare(Object[] lhs, Object[] rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            int minSize = Math.min(lhs.length, rhs.length);
            for (int index = 0; index < minSize; ++index) {
                Object lhsElement = lhs[index];
                Object rhsElement = rhs[index];
                int cmp = this.elementComparator.compare(this.coerceElement(lhsElement), this.coerceElement(rhsElement));
                if (cmp == 0) continue;
                return cmp;
            }
            if (lhs.length == rhs.length) {
                return 0;
            }
            if (lhs.length < rhs.length) {
                return -1;
            }
            return 1;
        }

        protected T coerceElement(Object element) {
            return (T)element;
        }
    }
}

