/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.druid.segment.ReferenceCountedObjectProvider;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;

public class JoinableClause
implements ReferenceCountedObjectProvider<Closeable> {
    private final String prefix;
    private final Joinable joinable;
    private final JoinType joinType;
    private final JoinConditionAnalysis condition;

    public JoinableClause(String prefix, Joinable joinable, JoinType joinType, JoinConditionAnalysis condition) {
        this.prefix = JoinPrefixUtils.validatePrefix(prefix);
        this.joinable = (Joinable)Preconditions.checkNotNull((Object)joinable, (Object)"joinable");
        this.joinType = (JoinType)Preconditions.checkNotNull((Object)joinType, (Object)"joinType");
        this.condition = (JoinConditionAnalysis)Preconditions.checkNotNull((Object)condition, (Object)"condition");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Joinable getJoinable() {
        return this.joinable;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public JoinConditionAnalysis getCondition() {
        return this.condition;
    }

    public List<String> getAvailableColumnsPrefixed() {
        return this.joinable.getAvailableColumns().stream().map(columnName -> this.prefix + columnName).collect(Collectors.toList());
    }

    public boolean includesColumn(String columnName) {
        return JoinPrefixUtils.isPrefixedBy(columnName, this.prefix);
    }

    public String unprefix(String columnName) {
        return JoinPrefixUtils.unprefix(columnName, this.prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinableClause that = (JoinableClause)o;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.joinable, that.joinable) && this.joinType == that.joinType && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.joinable, this.joinType, this.condition);
    }

    public String toString() {
        return "JoinableClause{prefix='" + this.prefix + "', joinable=" + String.valueOf(this.joinable) + ", joinType=" + String.valueOf(this.joinType) + ", condition=" + String.valueOf(this.condition) + "}";
    }

    @Override
    public Optional<Closeable> acquireReference() {
        return this.joinable.acquireReference();
    }
}

