/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.DataSourceMetadata;

public class ResetDataSourceMetadataAction
implements TaskAction<Boolean> {
    private final String supervisorId;
    private final String dataSource;
    private final DataSourceMetadata resetMetadata;

    public ResetDataSourceMetadataAction(@JsonProperty(value="supervisorId") @Nullable String supervisorId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="resetMetadata") DataSourceMetadata resetMetadata) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource cannot be null");
        this.supervisorId = (String)Preconditions.checkNotNull((Object)((String)Configs.valueOrDefault((Object)supervisorId, (Object)dataSource)), (Object)"supervisorId cannot be null");
        this.resetMetadata = resetMetadata;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public String getSupervisorId() {
        return this.supervisorId;
    }

    @JsonProperty
    public DataSourceMetadata getResetMetadata() {
        return this.resetMetadata;
    }

    @Override
    public TypeReference<Boolean> getReturnTypeReference() {
        return new TypeReference<Boolean>(){};
    }

    @Override
    public Boolean perform(Task task, TaskActionToolbox toolbox) {
        return toolbox.getSupervisorManager().resetSupervisor(this.supervisorId, this.resetMetadata);
    }

    @Override
    public String toString() {
        return "ResetDataSourceMetadataAction{dataSource='" + this.dataSource + "', supervisorId='" + this.supervisorId + "', resetMetadata=" + String.valueOf(this.resetMetadata) + "}";
    }
}

