/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.https;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.net.ssl.SSLContext;
import org.apache.druid.https.SSLClientConfig;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.security.TLSCertificateChecker;
import org.apache.druid.server.security.TLSUtils;

public class SSLContextProvider
implements Provider<SSLContext> {
    private static final EmittingLogger log = new EmittingLogger(SSLContextProvider.class);
    private SSLClientConfig config;
    private TLSCertificateChecker certificateChecker;

    @Inject
    public SSLContextProvider(SSLClientConfig config, TLSCertificateChecker certificateChecker) {
        this.config = config;
        this.certificateChecker = certificateChecker;
    }

    public SSLContext get() {
        log.info("Creating SslContext for https client using config [%s]", new Object[]{this.config});
        return new TLSUtils.ClientSSLContextBuilder().setProtocol(this.config.getProtocol()).setTrustStoreType(this.config.getTrustStoreType()).setTrustStorePath(this.config.getTrustStorePath()).setTrustStoreAlgorithm(this.config.getTrustStoreAlgorithm()).setTrustStorePasswordProvider(this.config.getTrustStorePasswordProvider()).setKeyStoreType(this.config.getKeyStoreType()).setKeyStorePath(this.config.getKeyStorePath()).setKeyStoreAlgorithm(this.config.getKeyManagerFactoryAlgorithm()).setCertAlias(this.config.getCertAlias()).setKeyStorePasswordProvider(this.config.getKeyStorePasswordProvider()).setKeyManagerFactoryPasswordProvider(this.config.getKeyManagerPasswordProvider()).setValidateHostnames(this.config.getValidateHostnames()).setCertificateChecker(this.certificateChecker).build();
    }
}

