/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ClaimSource;
import io.kubernetes.client.openapi.models.V1ClaimSourceBuilder;
import io.kubernetes.client.openapi.models.V1ClaimSourceFluentImpl;
import io.kubernetes.client.openapi.models.V1PodResourceClaim;
import io.kubernetes.client.openapi.models.V1PodResourceClaimFluent;
import java.util.Objects;

public class V1PodResourceClaimFluentImpl<A extends V1PodResourceClaimFluent<A>>
extends BaseFluent<A>
implements V1PodResourceClaimFluent<A> {
    private String name;
    private V1ClaimSourceBuilder source;

    public V1PodResourceClaimFluentImpl() {
    }

    public V1PodResourceClaimFluentImpl(V1PodResourceClaim instance) {
        if (instance != null) {
            this.withName(instance.getName());
            this.withSource(instance.getSource());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public V1ClaimSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public V1ClaimSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(V1ClaimSource source) {
        this._visitables.get("source").remove(this.source);
        if (source != null) {
            this.source = new V1ClaimSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get("source").remove(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public V1PodResourceClaimFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public V1PodResourceClaimFluent.SourceNested<A> withNewSourceLike(V1ClaimSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public V1PodResourceClaimFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public V1PodResourceClaimFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new V1ClaimSourceBuilder().build());
    }

    @Override
    public V1PodResourceClaimFluent.SourceNested<A> editOrNewSourceLike(V1ClaimSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodResourceClaimFluentImpl that = (V1PodResourceClaimFluentImpl)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.source, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source);
        }
        sb.append("}");
        return sb.toString();
    }

    class SourceNestedImpl<N>
    extends V1ClaimSourceFluentImpl<V1PodResourceClaimFluent.SourceNested<N>>
    implements V1PodResourceClaimFluent.SourceNested<N>,
    Nested<N> {
        V1ClaimSourceBuilder builder;

        SourceNestedImpl(V1ClaimSource item) {
            this.builder = new V1ClaimSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new V1ClaimSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodResourceClaimFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

