/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyWorkers")
public class TooManyWorkersFault
extends BaseMSQFault {
    static final String CODE = "TooManyWorkers";
    private final int workers;
    private final int maxWorkers;

    @JsonCreator
    public TooManyWorkersFault(@JsonProperty(value="workers") int workers, @JsonProperty(value="maxWorkers") int maxWorkers) {
        super(CODE, "Too many workers (current = %d; max = %d)", workers, maxWorkers);
        this.workers = workers;
        this.maxWorkers = maxWorkers;
    }

    @JsonProperty
    public int getWorkers() {
        return this.workers;
    }

    @JsonProperty
    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyWorkersFault that = (TooManyWorkersFault)o;
        return this.workers == that.workers && this.maxWorkers == that.maxWorkers;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.workers, this.maxWorkers);
    }

    @Override
    public String toString() {
        return "TooManyWorkersFault{workers=" + this.workers + ", maxWorkers=" + this.maxWorkers + "}";
    }
}

