/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.logical.stages;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.msq.exec.StageProcessor;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.inline.InlineInputSpec;
import org.apache.druid.msq.input.lookup.LookupInputSpec;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.msq.logical.LogicalInputSpec;
import org.apache.druid.msq.logical.StageMaker;
import org.apache.druid.msq.logical.stages.AbstractFrameProcessorStage;
import org.apache.druid.msq.logical.stages.FilterStage;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.ExpressionParser;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.DruidQueryGenerator;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.rel.logical.DruidAggregate;
import org.apache.druid.sql.calcite.rel.logical.DruidFilter;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.rel.logical.DruidProject;
import org.apache.druid.sql.calcite.rel.logical.DruidTableScan;
import org.apache.druid.sql.calcite.rel.logical.DruidValues;
import org.joda.time.Interval;

public class ReadStage
extends AbstractFrameProcessorStage {
    public ReadStage(RowSignature signature, LogicalInputSpec inputSpec) {
        super(signature, inputSpec);
    }

    protected ReadStage(ReadStage readStage, RowSignature newSignature) {
        super(newSignature, readStage.inputSpecs);
    }

    @Override
    public LogicalStage extendWith(DruidQueryGenerator.DruidNodeStack stack) {
        DruidLogicalNode node = stack.getNode();
        if (node instanceof DruidFilter) {
            DruidFilter filter = (DruidFilter)node;
            return this.makeFilterStage(stack.getPlannerContext(), filter);
        }
        if (node instanceof DruidProject || node instanceof DruidAggregate) {
            DruidLogicalNode project = node;
            DruidFilter dummyFilter = new DruidFilter(project.getCluster(), project.getTraitSet(), (RelNode)project, (RexNode)project.getCluster().getRexBuilder().makeLiteral(true));
            return this.makeFilterStage(stack.getPlannerContext(), dummyFilter).extendWith(stack);
        }
        return null;
    }

    private LogicalStage makeFilterStage(PlannerContext plannerContext, DruidFilter filter) {
        VirtualColumnRegistry virtualColumnRegistry = VirtualColumnRegistry.create((RowSignature)this.signature, (ExpressionParser)plannerContext.getExpressionParser(), (boolean)plannerContext.getPlannerConfig().isForceExpressionVirtualColumns());
        DimFilter dimFilter = DruidQuery.getDimFilter((PlannerContext)plannerContext, (RowSignature)this.signature, (VirtualColumnRegistry)virtualColumnRegistry, (Filter)filter);
        return new FilterStage(this, virtualColumnRegistry, dimFilter);
    }

    @Override
    public StageProcessor<?, ?> buildStageProcessor(StageMaker stageMaker) {
        return StageMaker.makeScanStageProcessor(VirtualColumns.EMPTY, this.signature, null);
    }

    public static Optional<ReadStage> buildReadStage(DruidQueryGenerator.DruidNodeStack stack) {
        DruidLogicalNode node = stack.getNode();
        if (node instanceof DruidValues || node instanceof DruidTableScan) {
            return ReadStage.translateViaSourceDesc(stack.getPlannerContext(), (SourceDescProducer)node);
        }
        return Optional.empty();
    }

    private static Optional<ReadStage> translateViaSourceDesc(PlannerContext plannerContext, SourceDescProducer node) {
        SourceDescProducer.SourceDesc sd = node.getSourceDesc(plannerContext, Collections.emptyList());
        InputSpec inputSpec = ReadStage.translateDataSource(sd.dataSource);
        ReadStage stage = new ReadStage(sd.rowSignature, LogicalInputSpec.of(inputSpec, sd.rowSignature));
        return Optional.of(stage);
    }

    @Nonnull
    private static InputSpec translateDataSource(DataSource dataSource) {
        if (dataSource instanceof TableDataSource) {
            TableDataSource ids = (TableDataSource)dataSource;
            TableInputSpec inputSpec = new TableInputSpec(ids.getName(), (List<Interval>)Intervals.ONLY_ETERNITY, null, null);
            return inputSpec;
        }
        if (dataSource instanceof InlineDataSource) {
            InlineDataSource ids = (InlineDataSource)dataSource;
            InlineInputSpec inputSpec = new InlineInputSpec(ids);
            return inputSpec;
        }
        if (dataSource instanceof LookupDataSource) {
            LookupDataSource lookupDataSource = (LookupDataSource)dataSource;
            return new LookupInputSpec(lookupDataSource.getLookupName());
        }
        throw DruidException.defensive((String)"This type of data source [%s] is not currently supported.", (Object[])new Object[]{dataSource.getClass()});
    }
}

