/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.run;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.Hook;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.planning.ExecutionVertex;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.sql.calcite.aggregation.DimensionExpression;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlResults;
import org.apache.druid.sql.hook.DruidHook;

public class NativeQueryMaker
implements QueryMaker {
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final PlannerContext plannerContext;
    private final ObjectMapper jsonMapper;
    private final List<Map.Entry<Integer, String>> fieldMapping;

    public NativeQueryMaker(QueryLifecycleFactory queryLifecycleFactory, PlannerContext plannerContext, ObjectMapper jsonMapper, List<Map.Entry<Integer, String>> fieldMapping) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.plannerContext = plannerContext;
        this.jsonMapper = jsonMapper;
        this.fieldMapping = fieldMapping;
    }

    @Override
    public QueryResponse<Object[]> runQuery(DruidQuery druidQuery) {
        List rowOrder;
        ExecutionVertex ev;
        Query<?> query = druidQuery.getQuery();
        if (this.plannerContext.getPlannerConfig().isRequireTimeCondition() && !(druidQuery.getDataSource() instanceof InlineDataSource) && Intervals.ONLY_ETERNITY.equals((Object)(ev = ExecutionVertex.of(query)).getEffectiveQuerySegmentSpec().getIntervals())) {
            throw new CannotBuildQueryException("requireTimeCondition is enabled, all queries must include a filter condition on the __time column");
        }
        int numFilters = this.plannerContext.getPlannerConfig().getMaxNumericInFilters();
        if (numFilters != -1 && query.getFilter() instanceof OrDimFilter) {
            OrDimFilter orDimFilter = (OrDimFilter)query.getFilter();
            int numBoundFilters = 0;
            for (DimFilter filter : orDimFilter.getFields()) {
                BoundDimFilter bound;
                if (!(filter instanceof BoundDimFilter) || !StringComparators.NUMERIC.equals((bound = (BoundDimFilter)filter).getOrdering()) || ++numBoundFilters <= numFilters) continue;
                throw new UOE(StringUtils.format((String)"The number of values in the IN clause for [%s] in query exceeds configured maxNumericFilter limit of [%s] for INs. Cast [%s] values of IN clause to String", (Object[])new Object[]{bound.getDimension(), numFilters, orDimFilter.getFields().size()}), new Object[0]);
            }
        }
        if (query instanceof TimeseriesQuery && !druidQuery.getGrouping().getDimensions().isEmpty()) {
            String timeDimension = ((DimensionExpression)Iterables.getOnlyElement(druidQuery.getGrouping().getDimensions())).getOutputName();
            rowOrder = druidQuery.getOutputRowSignature().getColumnNames().stream().map(f -> timeDimension.equals(f) ? "__time" : f).collect(Collectors.toList());
        } else {
            rowOrder = druidQuery.getOutputRowSignature().getColumnNames();
        }
        List columnTypes = druidQuery.getOutputRowType().getFieldList().stream().map(RelDataTypeField::getType).collect(Collectors.toList());
        return this.execute(query, NativeQueryMaker.mapColumnList(rowOrder, this.fieldMapping), NativeQueryMaker.mapColumnList(columnTypes, this.fieldMapping));
    }

    private <T> QueryResponse<Object[]> execute(Query<?> query, List<String> newFields, List<RelDataType> newTypes) {
        Hook.QUERY_PLAN.run(query);
        this.plannerContext.dispatchHook(DruidHook.NATIVE_PLAN, query);
        if (query.getId() == null) {
            String queryId = UUID.randomUUID().toString();
            this.plannerContext.addNativeQueryId(queryId);
            query = query.withId(queryId);
        } else {
            this.plannerContext.addNativeQueryId(query.getId());
        }
        query = query.withSqlQueryId(this.plannerContext.getSqlQueryId());
        AuthenticationResult authenticationResult = this.plannerContext.getAuthenticationResult();
        AuthorizationResult authorizationResult = this.plannerContext.getAuthorizationResult();
        QueryLifecycle queryLifecycle = this.queryLifecycleFactory.factorize();
        QueryResponse results = queryLifecycle.runSimple(query, authenticationResult, authorizationResult);
        return this.mapResultSequence(results, queryLifecycle.getToolChest(), query, newFields, newTypes);
    }

    private <T> QueryResponse<Object[]> mapResultSequence(QueryResponse<T> results, QueryToolChest<T, Query<T>> toolChest, Query<T> query, List<String> newFields, List<RelDataType> newTypes) {
        List originalFields = toolChest.resultArraySignature(query).getColumnNames();
        Object2IntOpenHashMap originalFieldsLookup = new Object2IntOpenHashMap();
        originalFieldsLookup.defaultReturnValue(-1);
        for (int i = 0; i < originalFields.size(); ++i) {
            originalFieldsLookup.put((Object)((String)originalFields.get(i)), i);
        }
        int[] mapping = new int[newFields.size()];
        for (int i = 0; i < newFields.size(); ++i) {
            String newField = newFields.get(i);
            int idx = originalFieldsLookup.getInt((Object)newField);
            if (idx < 0) {
                throw new ISE("newField[%s] not contained in originalFields[%s]", new Object[]{newField, String.join((CharSequence)", ", originalFields)});
            }
            mapping[i] = idx;
        }
        Sequence sequence = toolChest.resultsAsArrays(query, results.getResults());
        SqlResults.Context sqlResultsContext = SqlResults.Context.fromPlannerContext(this.plannerContext);
        return new QueryResponse(Sequences.map((Sequence)sequence, array -> {
            Object[] newArray = new Object[mapping.length];
            for (int i = 0; i < mapping.length; ++i) {
                newArray[i] = SqlResults.coerce(this.jsonMapper, sqlResultsContext, array[mapping[i]], ((RelDataType)newTypes.get(i)).getSqlTypeName(), (String)originalFields.get(mapping[i]));
            }
            return newArray;
        }), results.getResponseContext());
    }

    private static <T> List<T> mapColumnList(List<T> in, List<Map.Entry<Integer, String>> fieldMapping) {
        ArrayList<T> out = new ArrayList<T>(fieldMapping.size());
        for (Map.Entry<Integer, String> entry : fieldMapping) {
            out.add(in.get(entry.getKey()));
        }
        return out;
    }
}

