/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.api;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.protocol.api.EnhancedProtocolPluginFactory;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolRouter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocolRouter.class);
    private static final ProtocolRouter INSTANCE = new ProtocolRouter();
    private final Map<String, RoutingRule> routingRules = new ConcurrentHashMap<String, RoutingRule>();

    private ProtocolRouter() {
        this.initializeDefaultRules();
    }

    public static ProtocolRouter getInstance() {
        return INSTANCE;
    }

    public CloudEvent routeMessage(ProtocolTransportObject message, String preferredProtocol) throws ProtocolHandleException {
        String selectedProtocol;
        if (preferredProtocol != null && EnhancedProtocolPluginFactory.isProtocolSupported(preferredProtocol)) {
            try {
                ProtocolAdaptor<ProtocolTransportObject> adaptor = EnhancedProtocolPluginFactory.getProtocolAdaptor(preferredProtocol);
                if (adaptor.isValid(message)) {
                    return adaptor.toCloudEvent(message);
                }
            }
            catch (Exception e) {
                log.warn("Failed to process message with preferred protocol {}: {}", (Object)preferredProtocol, (Object)e.getMessage());
            }
        }
        if ((selectedProtocol = this.selectProtocolByRules(message)) != null) {
            try {
                ProtocolAdaptor<ProtocolTransportObject> adaptor = EnhancedProtocolPluginFactory.getProtocolAdaptor(selectedProtocol);
                return adaptor.toCloudEvent(message);
            }
            catch (Exception e) {
                log.warn("Failed to process message with rule-selected protocol {}: {}", (Object)selectedProtocol, (Object)e.getMessage());
            }
        }
        List<ProtocolAdaptor<ProtocolTransportObject>> adaptors = EnhancedProtocolPluginFactory.getProtocolAdaptorsByPriority();
        for (ProtocolAdaptor<ProtocolTransportObject> adaptor : adaptors) {
            try {
                if (!adaptor.isValid(message)) continue;
                log.debug("Using protocol {} for message routing", (Object)adaptor.getProtocolType());
                return adaptor.toCloudEvent(message);
            }
            catch (Exception e) {
                log.debug("Protocol {} failed to process message: {}", (Object)adaptor.getProtocolType(), (Object)e.getMessage());
            }
        }
        throw new ProtocolHandleException("No suitable protocol adaptor found for message type: " + message.getClass().getName());
    }

    public ProtocolTransportObject routeCloudEvent(CloudEvent cloudEvent, String targetProtocol) throws ProtocolHandleException {
        if (targetProtocol == null || targetProtocol.trim().isEmpty()) {
            throw new ProtocolHandleException("Target protocol type cannot be null or empty");
        }
        ProtocolAdaptor<ProtocolTransportObject> adaptor = EnhancedProtocolPluginFactory.getProtocolAdaptor(targetProtocol);
        return adaptor.fromCloudEvent(cloudEvent);
    }

    public void addRoutingRule(String ruleName, Predicate<ProtocolTransportObject> condition, String targetProtocol) {
        if (ruleName == null || condition == null || targetProtocol == null) {
            throw new IllegalArgumentException("Rule name, condition, and target protocol cannot be null");
        }
        this.routingRules.put(ruleName, new RoutingRule(condition, targetProtocol));
        log.info("Added routing rule: {} -> {}", (Object)ruleName, (Object)targetProtocol);
    }

    public void removeRoutingRule(String ruleName) {
        if (this.routingRules.remove(ruleName) != null) {
            log.info("Removed routing rule: {}", (Object)ruleName);
        }
    }

    public ProtocolAdaptor<ProtocolTransportObject> getBestProtocolForCapability(String capability) {
        List<ProtocolAdaptor<ProtocolTransportObject>> adaptors = EnhancedProtocolPluginFactory.getProtocolAdaptorsByCapability(capability);
        return adaptors.isEmpty() ? null : adaptors.get(0);
    }

    public List<CloudEvent> routeMessages(List<ProtocolTransportObject> messages, String preferredProtocol) throws ProtocolHandleException {
        if (messages == null || messages.isEmpty()) {
            throw new ProtocolHandleException("Messages list cannot be null or empty");
        }
        if (preferredProtocol != null) {
            try {
                ProtocolTransportObject batchMessage;
                ProtocolAdaptor<ProtocolTransportObject> adaptor = EnhancedProtocolPluginFactory.getProtocolAdaptor(preferredProtocol);
                if (adaptor.supportsBatchProcessing() && messages.size() > 1 && (batchMessage = this.createBatchMessage(messages)) != null && adaptor.isValid(batchMessage)) {
                    return adaptor.toBatchCloudEvent(batchMessage);
                }
            }
            catch (Exception e) {
                log.warn("Batch processing failed with preferred protocol {}: {}", (Object)preferredProtocol, (Object)e.getMessage());
            }
        }
        return messages.stream().map(message -> {
            try {
                return this.routeMessage((ProtocolTransportObject)message, preferredProtocol);
            }
            catch (ProtocolHandleException e) {
                log.error("Failed to route individual message", (Throwable)e);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private String selectProtocolByRules(ProtocolTransportObject message) {
        for (Map.Entry<String, RoutingRule> entry : this.routingRules.entrySet()) {
            try {
                if (!entry.getValue().condition.test(message)) continue;
                log.debug("Message matched routing rule: {} -> {}", (Object)entry.getKey(), (Object)entry.getValue().targetProtocol);
                return entry.getValue().targetProtocol;
            }
            catch (Exception e) {
                log.warn("Error evaluating routing rule {}: {}", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
        return null;
    }

    private void initializeDefaultRules() {
        this.addRoutingRule("http-messages", message -> message.getClass().getName().contains("Http"), "cloudevents");
        this.addRoutingRule("grpc-messages", message -> message.getClass().getName().contains("Grpc") || message.getClass().getName().contains("CloudEvent"), "cloudevents");
        this.addRoutingRule("tcp-messages", message -> message.getClass().getName().contains("Package"), "cloudevents");
        this.addRoutingRule("a2a-messages", message -> {
            if (message != null && message.getClass().getSimpleName().equals("RequestMessage")) {
                try {
                    String content = message.toString();
                    return content.contains("\"protocol\":\"A2A\"") || content.contains("A2A");
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }, "A2A");
        log.info("Initialized {} default routing rules", (Object)this.routingRules.size());
    }

    protected ProtocolTransportObject createBatchMessage(List<ProtocolTransportObject> messages) {
        return null;
    }

    private static class RoutingRule {
        final Predicate<ProtocolTransportObject> condition;
        final String targetProtocol;

        RoutingRule(Predicate<ProtocolTransportObject> condition, String targetProtocol) {
            this.condition = condition;
            this.targetProtocol = targetProtocol;
        }
    }
}

