/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc;

import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.grpc.StatusError;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;

public class StatusErrors {
    static final String CONNECTION_REFUSED_MESSAGE = "Connection refused: no further information";
    static final String CANCELLED_BEFORE_RECEIVING_HALF_CLOSE = "CANCELLED: cancelled before receiving half close";

    public static StatusError throwable(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            String message;
            StatusRuntimeException exception = (StatusRuntimeException)t;
            Status.Code code = exception.getStatus().getCode();
            if (code == Status.UNAVAILABLE.getCode()) {
                String causeMessage = StatusErrors.findCauseMessage(t, CONNECTION_REFUSED_MESSAGE, 2);
                if (causeMessage != null) {
                    String message2 = exception.getStatus().getDescription() + ": " + causeMessage;
                    return new SimpleStatusError(message2, t);
                }
            } else if (code == Status.CANCELLED.getCode() && StringUtils.contains((String)(message = exception.getMessage()), (String)CANCELLED_BEFORE_RECEIVING_HALF_CLOSE)) {
                return new SimpleStatusError(CANCELLED_BEFORE_RECEIVING_HALF_CLOSE, t);
            }
        }
        return new DefaultStatusError(t);
    }

    private static String findCauseMessage(Throwable t, String message, int maxDepth) {
        int depth = 0;
        for (Throwable cause = t.getCause(); cause != null && depth < maxDepth; cause = cause.getCause(), ++depth) {
            String causeMessage = cause.getMessage();
            if (StringUtils.startWith((String)causeMessage, (String)message)) {
                return causeMessage;
            }
            if (cause.getCause() == cause) break;
        }
        return null;
    }

    private static class DefaultStatusError
    implements StatusError {
        private final Throwable throwable;

        public DefaultStatusError(Throwable throwable) {
            this.throwable = throwable;
        }

        @Override
        public boolean isSimpleError() {
            return false;
        }

        @Override
        public String getMessage() {
            if (this.throwable != null) {
                return this.throwable.getMessage();
            }
            return "";
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    private static class SimpleStatusError
    implements StatusError {
        private final String message;
        private final Throwable throwable;

        public SimpleStatusError(String message, Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
        }

        @Override
        public boolean isSimpleError() {
            return true;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

