/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server.flowcontrol;

import com.navercorp.pinpoint.grpc.server.flowcontrol.IdleTimeout;
import com.navercorp.pinpoint.grpc.server.flowcontrol.RejectedExecutionListener;
import com.navercorp.pinpoint.grpc.server.flowcontrol.ServerCallWrapper;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowControlRejectExecutionListener
implements RejectedExecutionListener {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final Status STREAM_IDLE_TIMEOUT = Status.DEADLINE_EXCEEDED.withDescription("Stream idle timeout");
    private final String name;
    private final AtomicLong rejectedExecutionCounter = new AtomicLong(0L);
    private final ServerCallWrapper serverCall;
    private final long recoveryMessagesCount;
    private final IdleTimeout idleTimeout;
    private volatile Future<?> future;

    public FlowControlRejectExecutionListener(String name, ServerCallWrapper serverCall, long recoveryMessagesCount, IdleTimeout idleTimeout) {
        this.name = Objects.requireNonNull(name, "name");
        this.serverCall = Objects.requireNonNull(serverCall, "serverCall");
        this.recoveryMessagesCount = recoveryMessagesCount;
        this.idleTimeout = Objects.requireNonNull(idleTimeout, "idleTimeout");
    }

    @Override
    public void onRejectedExecution() {
        this.rejectedExecutionCounter.incrementAndGet();
    }

    @Override
    public void onSchedule() {
        if (!this.expireIdleTimeout()) {
            this.reject();
        }
    }

    private boolean expireIdleTimeout() {
        if (this.idleTimeExpired() && this.cancel()) {
            this.idleTimeout();
            return true;
        }
        return false;
    }

    private void reject() {
        long currentRejectCount = this.rejectedExecutionCounter.get();
        if (currentRejectCount > 0L) {
            long recovery = Math.min(currentRejectCount, this.recoveryMessagesCount);
            this.rejectedExecutionCounter.addAndGet(-recovery);
            this.serverCall.request((int)recovery);
        }
    }

    @Override
    public long getRejectedExecutionCount() {
        return this.rejectedExecutionCounter.get();
    }

    @Override
    public void onMessage() {
        this.idleTimeout.update();
    }

    private boolean idleTimeExpired() {
        return this.idleTimeout.isExpired();
    }

    @Override
    public void setFuture(Future<?> future) {
        this.future = Objects.requireNonNull(future, "future");
    }

    @Override
    public boolean cancel() {
        Future<?> future = this.future;
        if (future == null) {
            return false;
        }
        return future.cancel(false);
    }

    @Override
    public boolean isCancelled() {
        Future<?> future = this.future;
        if (future == null) {
            return false;
        }
        return future.isCancelled();
    }

    private void idleTimeout() {
        this.logger.info("stream idle timeout applicationName:{} agentId:{} {}", (Object)this.name, (Object)this.serverCall.getApplicationName(), (Object)this.serverCall.getAgentId());
        this.serverCall.cancel(STREAM_IDLE_TIMEOUT, new Metadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RejectedExecutionListener{");
        sb.append("rejectedExecutionCounter=").append(this.rejectedExecutionCounter);
        sb.append(", serverCall=").append(this.serverCall);
        sb.append('}');
        return sb.toString();
    }
}

