/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server.flowcontrol;

import com.navercorp.pinpoint.grpc.server.flowcontrol.IdleTimeout;
import com.navercorp.pinpoint.grpc.server.flowcontrol.RejectedExecutionListener;
import com.navercorp.pinpoint.grpc.server.flowcontrol.ServerCallWrapper;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Objects;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleRejectedExecutionListener
implements RejectedExecutionListener {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final Status STREAM_IDLE_TIMEOUT = Status.DEADLINE_EXCEEDED.withDescription("Stream idle timeout");
    private final String name;
    private final ServerCallWrapper serverCall;
    private final IdleTimeout idleTimeout;
    private volatile Future<?> future;

    public SimpleRejectedExecutionListener(String name, ServerCallWrapper serverCall, IdleTimeout idleTimeout) {
        this.name = Objects.requireNonNull(name, "name");
        this.serverCall = Objects.requireNonNull(serverCall, "serverCall");
        this.idleTimeout = Objects.requireNonNull(idleTimeout, "idleTimeout");
    }

    @Override
    public void onRejectedExecution() {
        this.serverCall.request(1);
    }

    @Override
    public void onSchedule() {
    }

    @Override
    public long getRejectedExecutionCount() {
        return 0L;
    }

    @Override
    public void onMessage() {
        this.idleTimeout.update();
    }

    private boolean idleTimeExpired() {
        return this.idleTimeout.isExpired();
    }

    private void idleTimeout() {
        this.logger.info("stream idle timeout applicationName:{} agentId:{} {}", (Object)this.serverCall.getApplicationName(), (Object)this.serverCall.getAgentId(), (Object)this.name);
        this.serverCall.cancel(STREAM_IDLE_TIMEOUT, new Metadata());
    }

    @Override
    public void setFuture(Future<?> future) {
        this.future = Objects.requireNonNull(future, "future");
    }

    @Override
    public boolean cancel() {
        Future<?> future = this.future;
        if (future == null) {
            return false;
        }
        return future.cancel(false);
    }

    @Override
    public boolean isCancelled() {
        Future<?> future = this.future;
        if (future == null) {
            return false;
        }
        return future.isCancelled();
    }

    public String toString() {
        return "SimpleRejectedExecutionListener{serverCall=" + this.serverCall + '}';
    }
}

