/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import io.cloudevents.CloudEventData;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class JsonCloudEventData
implements CloudEventData {
    private final JsonNode node;

    public JsonCloudEventData(JsonNode node) {
        Objects.requireNonNull(node);
        this.node = node;
    }

    public byte[] toBytes() {
        return this.node.toString().getBytes(StandardCharsets.UTF_8);
    }

    public JsonNode getNode() {
        return this.node;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonCloudEventData that = (JsonCloudEventData)o;
        return Objects.equals(this.getNode(), that.getNode());
    }

    public int hashCode() {
        return Objects.hash(this.getNode());
    }

    public String toString() {
        return "JsonCloudEventData{node=" + this.node + '}';
    }

    public static JsonCloudEventData wrap(JsonNode node) {
        return new JsonCloudEventData(node);
    }
}

