/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.store.model;

import com.alibaba.otter.canal.common.utils.CanalToStringStyle;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.position.LogIdentity;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Event
implements Serializable {
    private static final long serialVersionUID = 1333330351758762739L;
    private LogIdentity logIdentity;
    private ByteString rawEntry;
    private long executeTime;
    private CanalEntry.EntryType entryType;
    private String journalName;
    private long position;
    private long serverId;
    private CanalEntry.EventType eventType;
    private String gtid;
    private long rawLength;
    private int rowsCount;
    private CanalEntry.Entry entry;

    public Event() {
    }

    public Event(LogIdentity logIdentity, CanalEntry.Entry entry) {
        this(logIdentity, entry, true);
    }

    public Event(LogIdentity logIdentity, CanalEntry.Entry entry, boolean raw) {
        List props;
        this.logIdentity = logIdentity;
        this.entryType = entry.getEntryType();
        this.executeTime = entry.getHeader().getExecuteTime();
        this.journalName = entry.getHeader().getLogfileName();
        this.position = entry.getHeader().getLogfileOffset();
        this.serverId = entry.getHeader().getServerId();
        this.gtid = entry.getHeader().getGtid();
        this.eventType = entry.getHeader().getEventType();
        if (this.entryType == CanalEntry.EntryType.ROWDATA && (props = entry.getHeader().getPropsList()) != null) {
            for (CanalEntry.Pair p : props) {
                if (!"rowsCount".equals(p.getKey())) continue;
                this.rowsCount = Integer.parseInt(p.getValue());
                break;
            }
        }
        if (raw) {
            this.rawEntry = entry.toByteString();
            this.rawLength = this.rawEntry.size();
        } else {
            this.entry = entry;
            this.rawLength = entry.getHeader().getEventLength() * 6L;
        }
    }

    public LogIdentity getLogIdentity() {
        return this.logIdentity;
    }

    public void setLogIdentity(LogIdentity logIdentity) {
        this.logIdentity = logIdentity;
    }

    public ByteString getRawEntry() {
        return this.rawEntry;
    }

    public void setRawEntry(ByteString rawEntry) {
        this.rawEntry = rawEntry;
    }

    public long getExecuteTime() {
        return this.executeTime;
    }

    public void setExecuteTime(long executeTime) {
        this.executeTime = executeTime;
    }

    public CanalEntry.EntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(CanalEntry.EntryType entryType) {
        this.entryType = entryType;
    }

    public String getJournalName() {
        return this.journalName;
    }

    public void setJournalName(String journalName) {
        this.journalName = journalName;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public String getGtid() {
        return this.gtid;
    }

    public void setGtid(String gtid) {
        this.gtid = gtid;
    }

    public long getRawLength() {
        return this.rawLength;
    }

    public void setRawLength(long rawLength) {
        this.rawLength = rawLength;
    }

    public CanalEntry.EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(CanalEntry.EventType eventType) {
        this.eventType = eventType;
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public void setRowsCount(int rowsCount) {
        this.rowsCount = rowsCount;
    }

    public CanalEntry.Entry getEntry() {
        return this.entry;
    }

    public void setEntry(CanalEntry.Entry entry) {
        this.entry = entry;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)CanalToStringStyle.DEFAULT_STYLE);
    }
}

