/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonExpirable;
import org.redisson.api.RBloomFilter;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.Hash;

public class RedissonBloomFilter<T>
extends RedissonExpirable
implements RBloomFilter<T> {
    volatile long size;
    volatile int hashIterations;
    final CommandAsyncExecutor commandExecutor;
    String configName;

    protected RedissonBloomFilter(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.configName = RedissonBloomFilter.suffixName(this.getRawName(), "config");
    }

    protected RedissonBloomFilter(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.configName = RedissonBloomFilter.suffixName(this.getRawName(), "config");
    }

    private int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    private long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] hash(Object object) {
        ByteBuf state = this.encode(object);
        try {
            long[] lArray = Hash.hash128(state);
            return lArray;
        }
        finally {
            state.release();
        }
    }

    @Override
    public boolean add(T object) {
        return this.add((Collection<T>)Arrays.asList(object)) > 0L;
    }

    @Override
    public RFuture<Boolean> addAsync(T object) {
        CompletionStage<Boolean> f = this.addAsync((Collection<T>)Arrays.asList(object)).thenApply(r -> r > 0L);
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public RFuture<Long> addAsync(Collection<T> objects) {
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        if (this.size == 0L) {
            future = this.readConfigAsync();
        }
        CompletionStage f = future.thenCompose(r -> {
            List<Long> allIndexes = this.index(objects);
            ArrayList<Number> params = new ArrayList<Number>();
            params.add(this.size);
            params.add(this.hashIterations);
            int s = allIndexes.size() / objects.size();
            params.add(s);
            params.addAll(allIndexes);
            return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local size = redis.call('hget', KEYS[1], 'size');local hashIterations = redis.call('hget', KEYS[1], 'hashIterations');assert(size == ARGV[1] and hashIterations == ARGV[2], 'Bloom filter config has been changed')local k = 0;local c = 0;for i = 4, #ARGV, 1 do local r = redis.call('setbit', KEYS[2], ARGV[i], 1); if r == 0 then k = k + 1;end; if ((i - 4) + 1) % ARGV[3] == 0 then if k > 0 then c = c + 1;end; k = 0; end; end; return c;", Arrays.asList(this.configName, this.getRawName()), params.toArray());
        });
        return new CompletableFutureWrapper<Long>(f);
    }

    @Override
    public long add(Collection<T> objects) {
        return this.get(this.addAsync(objects));
    }

    private long[] hash(long hash1, long hash2, int iterations, long size) {
        long[] indexes = new long[iterations];
        long hash = hash1;
        for (int i = 0; i < iterations; ++i) {
            indexes[i] = (hash & Long.MAX_VALUE) % size;
            if (i % 2 == 0) {
                hash += hash2;
                continue;
            }
            hash += hash1;
        }
        return indexes;
    }

    @Override
    public RFuture<Long> containsAsync(Collection<T> objects) {
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        if (this.size == 0L) {
            future = this.readConfigAsync();
        }
        CompletionStage f = future.thenCompose(r -> {
            List<Long> allIndexes = this.index(objects);
            ArrayList<Number> params = new ArrayList<Number>();
            params.add(this.size);
            params.add(this.hashIterations);
            params.add(objects.size());
            params.addAll(allIndexes);
            return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local size = redis.call('hget', KEYS[1], 'size');local hashIterations = redis.call('hget', KEYS[1], 'hashIterations');assert(size == ARGV[1] and hashIterations == ARGV[2], 'Bloom filter config has been changed')local k = 0;local c = 0;local cc = (#ARGV - 3) / ARGV[3];for i = 4, #ARGV, 1 do local r = redis.call('getbit', KEYS[2], ARGV[i]); if r == 0 then k = k + 1;end; if ((i - 4) + 1) % cc == 0 then if k > 0 then c = c + 1;end; k = 0; end; end; return ARGV[3] - c;", Arrays.asList(this.configName, this.getRawName()), params.toArray());
        });
        return new CompletableFutureWrapper<Long>(f);
    }

    @Override
    public long contains(Collection<T> objects) {
        return (Long)((Object)this.get(this.containsAsync((T)objects)));
    }

    List<Long> index(Collection<T> objects) {
        LinkedList<Long> allIndexes = new LinkedList<Long>();
        for (T object : objects) {
            long[] hashes = this.hash(object);
            long[] indexes = this.hash(hashes[0], hashes[1], this.hashIterations, this.size);
            allIndexes.addAll(Arrays.stream(indexes).boxed().collect(Collectors.toList()));
        }
        return allIndexes;
    }

    @Override
    public boolean contains(T object) {
        return this.contains((Collection<T>)Arrays.asList(object)) > 0L;
    }

    @Override
    public RFuture<Boolean> containsAsync(T object) {
        CompletionStage<Boolean> f = this.containsAsync((T)Arrays.asList(object)).thenApply(r -> r > 0L);
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public long count() {
        return this.get(this.countAsync());
    }

    @Override
    public RFuture<Long> countAsync() {
        CompletionStage<Void> f = this.readConfigAsync();
        CompletionStage res = f.thenCompose(r -> {
            RedissonBitSet bs = new RedissonBitSet(this.commandExecutor, this.getName());
            return bs.cardinalityAsync().thenApply(c -> Math.round((double)(-this.size) / (double)this.hashIterations * Math.log(1.0 - (double)c.longValue() / (double)this.size)));
        });
        return new CompletableFutureWrapper<Long>(res);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.configName);
    }

    @Override
    public RFuture<Boolean> copyAsync(List<Object> keys, int database, boolean replace) {
        String newName = (String)keys.get(1);
        List<Object> kks = Arrays.asList(this.getRawName(), this.configName, newName, RedissonBloomFilter.suffixName(newName, "config"));
        return super.copyAsync(kks, database, replace);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.configName);
        return super.sizeInMemoryAsync(keys);
    }

    CompletionStage<Void> readConfigAsync() {
        RFuture future = this.commandExecutor.readAsync(this.configName, (Codec)StringCodec.INSTANCE, new RedisCommand("HGETALL", new ObjectMapReplayDecoder()), this.configName);
        return future.thenAccept(config -> this.readConfig((Map<String, String>)config));
    }

    private void readConfig(Map<String, String> config) {
        if (config.get("hashIterations") == null || config.get("size") == null) {
            throw new IllegalStateException("Bloom filter is not initialized!");
        }
        this.size = Long.valueOf(config.get("size"));
        this.hashIterations = Integer.valueOf(config.get("hashIterations"));
    }

    protected long getMaxSize() {
        return 0xFFFFFFFEL;
    }

    @Override
    public boolean tryInit(long expectedInsertions, double falseProbability) {
        return this.get(this.tryInitAsync(expectedInsertions, falseProbability));
    }

    @Override
    public RFuture<Boolean> tryInitAsync(long expectedInsertions, double falseProbability) {
        if (falseProbability > 1.0) {
            throw new IllegalArgumentException("Bloom filter false probability can't be greater than 1");
        }
        if (falseProbability < 0.0) {
            throw new IllegalArgumentException("Bloom filter false probability can't be negative");
        }
        this.size = this.optimalNumOfBits(expectedInsertions, falseProbability);
        if (this.size == 0L) {
            throw new IllegalArgumentException("Bloom filter calculated size is " + this.size);
        }
        if (this.size > this.getMaxSize()) {
            throw new IllegalArgumentException("Bloom filter size can't be greater than " + this.getMaxSize() + ". But calculated size is " + this.size);
        }
        this.hashIterations = this.optimalNumOfHashFunctions(expectedInsertions, this.size);
        return this.commandExecutor.evalWriteAsync(this.configName, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[1]) == 1 then return 0;end; redis.call('hset', KEYS[1], 'size', ARGV[1]);redis.call('hset', KEYS[1], 'hashIterations', ARGV[2]);redis.call('hset', KEYS[1], 'expectedInsertions', ARGV[3]);redis.call('hset', KEYS[1], 'falseProbability', ARGV[4]);return 1;", Arrays.asList(this.configName), this.size, this.hashIterations, expectedInsertions, falseProbability);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.configName);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.configName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.configName);
    }

    @Override
    public long getExpectedInsertions() {
        return this.get(this.getExpectedInsertionsAsync());
    }

    @Override
    public RFuture<Long> getExpectedInsertionsAsync() {
        return this.readSettingAsync(RedisCommands.EVAL_LONG, LongCodec.INSTANCE, "expectedInsertions");
    }

    private <T> RFuture<T> readSettingAsync(RedisCommand<T> evalCommandType, Codec codec, String settingName) {
        return this.commandExecutor.evalReadAsync(this.configName, codec, evalCommandType, "if redis.call('exists', KEYS[1]) == 0 then assert(false, 'Bloom filter is not initialized')end; return redis.call('hget', KEYS[1], ARGV[1]);", Arrays.asList(this.configName), settingName);
    }

    @Override
    public double getFalseProbability() {
        return this.get(this.getFalseProbabilityAsync());
    }

    @Override
    public RFuture<Double> getFalseProbabilityAsync() {
        return this.readSettingAsync(RedisCommands.EVAL_DOUBLE, DoubleCodec.INSTANCE, "falseProbability");
    }

    @Override
    public long getSize() {
        return this.get(this.getSizeAsync());
    }

    @Override
    public RFuture<Long> getSizeAsync() {
        return this.readSettingAsync(RedisCommands.EVAL_LONG, LongCodec.INSTANCE, "size");
    }

    @Override
    public int getHashIterations() {
        return this.get(this.getHashIterationsAsync());
    }

    @Override
    public RFuture<Integer> getHashIterationsAsync() {
        return this.readSettingAsync(RedisCommands.EVAL_INTEGER, LongCodec.INSTANCE, "hashIterations");
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.EXISTS, this.getRawName(), this.configName);
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        String nn = this.mapName(newName);
        String newConfigName = RedissonBloomFilter.suffixName(nn, "config");
        List<Object> kks = Arrays.asList(this.getRawName(), this.configName, nn, newConfigName);
        return this.renameAsync(this.commandExecutor, kks, () -> {
            this.setName(newName);
            this.configName = newConfigName;
        });
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        String nn = this.mapName(newName);
        String newConfigName = RedissonBloomFilter.suffixName(nn, "config");
        List<Object> kks = Arrays.asList(this.getRawName(), this.configName, nn, newConfigName);
        return this.renamenxAsync(this.commandExecutor, kks, value -> {
            if (value.booleanValue()) {
                this.setName(newName);
                this.configName = newConfigName;
            }
        });
    }
}

