/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.incubator.channel.uring.IOUringChannelOption;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.util.HashedWheelTimer;
import io.netty.util.NetUtil;
import io.netty.util.Timer;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.handler.RedisChannelInitializer;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.RedisURI;

public final class RedisClient {
    private final AtomicReference<CompletableFuture<InetSocketAddress>> resolvedAddrFuture = new AtomicReference();
    private final Bootstrap bootstrap;
    private final Bootstrap pubSubBootstrap;
    private final RedisURI uri;
    private InetSocketAddress resolvedAddr;
    private final ChannelGroup channels;
    private ExecutorService executor;
    private final long commandTimeout;
    private Timer timer;
    private RedisClientConfig config;
    private boolean hasOwnTimer;
    private boolean hasOwnExecutor;
    private boolean hasOwnGroup;
    private boolean hasOwnResolver;
    private volatile boolean shutdown;

    public static RedisClient create(RedisClientConfig config) {
        return new RedisClient(config);
    }

    private RedisClient(RedisClientConfig config) {
        RedisClientConfig copy = new RedisClientConfig(config);
        if (copy.getTimer() == null) {
            copy.setTimer((Timer)new HashedWheelTimer());
            this.hasOwnTimer = true;
        }
        if (copy.getGroup() == null) {
            copy.setGroup((EventLoopGroup)new NioEventLoopGroup());
            this.hasOwnGroup = true;
        }
        if (copy.getExecutor() == null) {
            copy.setExecutor(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2));
            this.hasOwnExecutor = true;
        }
        if (copy.getResolverGroup() == null) {
            if (config.getSocketChannelClass() == EpollSocketChannel.class) {
                copy.setResolverGroup((AddressResolverGroup<InetSocketAddress>)new DnsAddressResolverGroup(EpollDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault()));
            } else if (config.getSocketChannelClass() == KQueueSocketChannel.class) {
                copy.setResolverGroup((AddressResolverGroup<InetSocketAddress>)new DnsAddressResolverGroup(KQueueDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault()));
            } else {
                copy.setResolverGroup((AddressResolverGroup<InetSocketAddress>)new DnsAddressResolverGroup(NioDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault()));
            }
            this.hasOwnResolver = true;
        }
        this.config = copy;
        this.executor = copy.getExecutor();
        this.timer = copy.getTimer();
        this.uri = copy.getAddress();
        this.resolvedAddr = copy.getAddr();
        if (this.resolvedAddr != null) {
            this.resolvedAddrFuture.set(CompletableFuture.completedFuture(this.resolvedAddr));
        }
        this.channels = new DefaultChannelGroup((EventExecutor)copy.getGroup().next());
        this.bootstrap = this.createBootstrap(copy, RedisChannelInitializer.Type.PLAIN);
        this.pubSubBootstrap = this.createBootstrap(copy, RedisChannelInitializer.Type.PUBSUB);
        this.commandTimeout = copy.getCommandTimeout();
    }

    private Bootstrap createBootstrap(RedisClientConfig config, RedisChannelInitializer.Type type) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().resolver(config.getResolverGroup()).channel(config.getSocketChannelClass())).group(config.getGroup());
        bootstrap.handler((ChannelHandler)new RedisChannelInitializer(bootstrap, config, this, this.channels, type));
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)config.isKeepAlive());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)config.isTcpNoDelay());
        this.applyChannelOptions(config, bootstrap);
        config.getNettyHook().afterBoostrapInitialization(bootstrap);
        return bootstrap;
    }

    private void applyChannelOptions(RedisClientConfig config, Bootstrap bootstrap) {
        if (config.getSocketChannelClass() == NioSocketChannel.class) {
            SocketOption countOption = null;
            SocketOption idleOption = null;
            SocketOption intervalOption = null;
            try {
                Class<?> options = Class.forName("jdk.net.ExtendedSocketOptions");
                countOption = (SocketOption)options.getDeclaredField("TCP_KEEPCOUNT").get(null);
                idleOption = (SocketOption)options.getDeclaredField("TCP_KEEPIDLE").get(null);
                intervalOption = (SocketOption)options.getDeclaredField("TCP_KEEPINTERVAL").get(null);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            if (config.getTcpKeepAliveCount() > 0 && countOption != null) {
                bootstrap.option(NioChannelOption.of((SocketOption)countOption), (Object)config.getTcpKeepAliveCount());
            }
            if (config.getTcpKeepAliveIdle() > 0 && idleOption != null) {
                bootstrap.option(NioChannelOption.of(idleOption), (Object)config.getTcpKeepAliveIdle());
            }
            if (config.getTcpKeepAliveInterval() > 0 && intervalOption != null) {
                bootstrap.option(NioChannelOption.of(intervalOption), (Object)config.getTcpKeepAliveInterval());
            }
        } else if (config.getSocketChannelClass() == EpollSocketChannel.class) {
            if (config.getTcpKeepAliveCount() > 0) {
                bootstrap.option(EpollChannelOption.TCP_KEEPCNT, (Object)config.getTcpKeepAliveCount());
            }
            if (config.getTcpKeepAliveIdle() > 0) {
                bootstrap.option(EpollChannelOption.TCP_KEEPIDLE, (Object)config.getTcpKeepAliveIdle());
            }
            if (config.getTcpKeepAliveInterval() > 0) {
                bootstrap.option(EpollChannelOption.TCP_KEEPINTVL, (Object)config.getTcpKeepAliveInterval());
            }
            if (config.getTcpUserTimeout() > 0) {
                bootstrap.option(EpollChannelOption.TCP_USER_TIMEOUT, (Object)config.getTcpUserTimeout());
            }
        } else if (config.getSocketChannelClass() == IOUringSocketChannel.class) {
            if (config.getTcpKeepAliveCount() > 0) {
                bootstrap.option(IOUringChannelOption.TCP_KEEPCNT, (Object)config.getTcpKeepAliveCount());
            }
            if (config.getTcpKeepAliveIdle() > 0) {
                bootstrap.option(IOUringChannelOption.TCP_KEEPIDLE, (Object)config.getTcpKeepAliveIdle());
            }
            if (config.getTcpKeepAliveInterval() > 0) {
                bootstrap.option(IOUringChannelOption.TCP_KEEPINTVL, (Object)config.getTcpKeepAliveInterval());
            }
            if (config.getTcpUserTimeout() > 0) {
                bootstrap.option(IOUringChannelOption.TCP_USER_TIMEOUT, (Object)config.getTcpUserTimeout());
            }
        }
    }

    public InetSocketAddress getAddr() {
        return this.resolvedAddr;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public RedisClientConfig getConfig() {
        return this.config;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public RedisConnection connect() {
        try {
            return (RedisConnection)this.connectAsync().toCompletableFuture().join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RedisException) {
                throw (RedisException)e.getCause();
            }
            throw new RedisConnectionException("Unable to connect to: " + this.uri, e);
        }
    }

    public CompletableFuture<InetSocketAddress> resolveAddr() {
        if (this.resolvedAddrFuture.get() != null) {
            return this.resolvedAddrFuture.get();
        }
        CompletableFuture<InetSocketAddress> promise = new CompletableFuture<InetSocketAddress>();
        if (!this.resolvedAddrFuture.compareAndSet(null, promise)) {
            return this.resolvedAddrFuture.get();
        }
        byte[] addr = NetUtil.createByteArrayFromIpAddressString((String)this.uri.getHost());
        if (addr != null) {
            try {
                this.resolvedAddr = new InetSocketAddress(InetAddress.getByAddress(this.uri.getHost(), addr), this.uri.getPort());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            promise.complete(this.resolvedAddr);
            return promise;
        }
        AddressResolver resolver = this.bootstrap.config().resolver().getResolver((EventExecutor)this.bootstrap.config().group().next());
        Future resolveFuture = resolver.resolve((SocketAddress)InetSocketAddress.createUnresolved(this.uri.getHost(), this.uri.getPort()));
        resolveFuture.addListener((GenericFutureListener)((FutureListener)future -> {
            if (!future.isSuccess()) {
                promise.completeExceptionally(new RedisConnectionException(future.cause()));
                return;
            }
            InetSocketAddress resolved = (InetSocketAddress)future.getNow();
            byte[] addr1 = resolved.getAddress().getAddress();
            this.resolvedAddr = new InetSocketAddress(InetAddress.getByAddress(this.uri.getHost(), addr1), resolved.getPort());
            promise.complete(this.resolvedAddr);
        }));
        return promise;
    }

    public RFuture<RedisConnection> connectAsync() {
        CompletableFuture<InetSocketAddress> addrFuture = this.resolveAddr();
        CompletionStage f = addrFuture.thenCompose(res -> {
            final CompletableFuture r = new CompletableFuture();
            ChannelFuture channelFuture = this.bootstrap.connect((SocketAddress)res);
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(final ChannelFuture future) throws Exception {
                    if (RedisClient.this.isShutdown()) {
                        RedisConnectionException cause = new RedisConnectionException("RedisClient is shutdown");
                        r.completeExceptionally(cause);
                        return;
                    }
                    if (future.isSuccess()) {
                        Object c = RedisConnection.getFrom(future.channel());
                        ((RedisConnection)c).getConnectionPromise().whenComplete((res, e) -> RedisClient.this.bootstrap.config().group().execute(new Runnable(){
                            final /* synthetic */ Throwable val$e;
                            final /* synthetic */ CompletableFuture val$r;
                            final /* synthetic */ RedisConnection val$c;
                            {
                                this.val$e = throwable;
                                this.val$r = completableFuture;
                                this.val$c = redisConnection;
                            }

                            @Override
                            public void run() {
                                if (this.val$e == null) {
                                    if (!this.val$r.complete(this.val$c)) {
                                        this.val$c.closeAsync();
                                    } else {
                                        RedisClient.this.executor.execute(() -> {
                                            if (RedisClient.this.config.getConnectedListener() != null) {
                                                RedisClient.this.config.getConnectedListener().accept(RedisClient.this.getAddr());
                                            }
                                        });
                                    }
                                } else {
                                    this.val$r.completeExceptionally(this.val$e);
                                    this.val$c.closeAsync();
                                }
                            }
                        }));
                    } else {
                        RedisClient.this.bootstrap.config().group().execute(new Runnable(){

                            @Override
                            public void run() {
                                r.completeExceptionally(future.cause());
                            }
                        });
                    }
                }
            });
            return r;
        });
        return new CompletableFutureWrapper<RedisConnection>((CompletableFuture<RedisConnection>)f);
    }

    public RedisPubSubConnection connectPubSub() {
        try {
            return (RedisPubSubConnection)this.connectPubSubAsync().toCompletableFuture().join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RedisException) {
                throw (RedisException)e.getCause();
            }
            throw new RedisConnectionException("Unable to connect to: " + this.uri, e);
        }
    }

    public RFuture<RedisPubSubConnection> connectPubSubAsync() {
        CompletableFuture<InetSocketAddress> nameFuture = this.resolveAddr();
        CompletionStage f = nameFuture.thenCompose(res -> {
            final CompletableFuture r = new CompletableFuture();
            ChannelFuture channelFuture = this.pubSubBootstrap.connect((SocketAddress)res);
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(final ChannelFuture future) throws Exception {
                    if (RedisClient.this.isShutdown()) {
                        RedisConnectionException cause = new RedisConnectionException("RedisClient is shutdown");
                        r.completeExceptionally(cause);
                        return;
                    }
                    if (future.isSuccess()) {
                        RedisPubSubConnection c = (RedisPubSubConnection)RedisPubSubConnection.getFrom(future.channel());
                        c.getConnectionPromise().whenComplete((res, e) -> RedisClient.this.pubSubBootstrap.config().group().execute(new Runnable(){
                            final /* synthetic */ Throwable val$e;
                            final /* synthetic */ CompletableFuture val$r;
                            final /* synthetic */ RedisPubSubConnection val$c;
                            {
                                this.val$e = throwable;
                                this.val$r = completableFuture;
                                this.val$c = redisPubSubConnection;
                            }

                            @Override
                            public void run() {
                                if (this.val$e == null) {
                                    if (!this.val$r.complete(this.val$c)) {
                                        this.val$c.closeAsync();
                                    }
                                } else {
                                    this.val$r.completeExceptionally(this.val$e);
                                    this.val$c.closeAsync();
                                }
                            }
                        }));
                    } else {
                        RedisClient.this.pubSubBootstrap.config().group().execute(new Runnable(){

                            @Override
                            public void run() {
                                r.completeExceptionally(future.cause());
                            }
                        });
                    }
                }
            });
            return r;
        });
        return new CompletableFutureWrapper<RedisPubSubConnection>((CompletableFuture<RedisPubSubConnection>)f);
    }

    public void shutdown() {
        this.shutdownAsync().toCompletableFuture().join();
    }

    public RFuture<Void> shutdownAsync() {
        this.shutdown = true;
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (this.channels.isEmpty() || this.config.getGroup().isShuttingDown()) {
            this.shutdown(result);
            return new CompletableFutureWrapper<Void>(result);
        }
        for (Channel channel : this.channels) {
            Object connection = RedisConnection.getFrom(channel);
            if (connection == null) continue;
            ((RedisConnection)connection).closeAsync();
        }
        ChannelGroupFuture channelsFuture = this.channels.close();
        channelsFuture.addListener((GenericFutureListener)new FutureListener<Void>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    result.completeExceptionally(future.cause());
                    return;
                }
                RedisClient.this.shutdown(result);
            }
        });
        return new CompletableFutureWrapper<Void>(result);
    }

    public boolean isShutdown() {
        return this.shutdown || this.bootstrap.config().group().isShuttingDown();
    }

    private void shutdown(final CompletableFuture<Void> result) {
        if (!(this.hasOwnTimer || this.hasOwnExecutor || this.hasOwnResolver || this.hasOwnGroup)) {
            result.complete(null);
        } else {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        if (RedisClient.this.hasOwnTimer) {
                            RedisClient.this.timer.stop();
                        }
                        if (RedisClient.this.hasOwnExecutor) {
                            RedisClient.this.executor.shutdown();
                            RedisClient.this.executor.awaitTermination(15L, TimeUnit.SECONDS);
                        }
                        if (RedisClient.this.hasOwnResolver) {
                            RedisClient.this.bootstrap.config().resolver().close();
                        }
                        if (RedisClient.this.hasOwnGroup) {
                            RedisClient.this.bootstrap.config().group().shutdownGracefully();
                        }
                    }
                    catch (Exception e) {
                        result.completeExceptionally(e);
                        return;
                    }
                    result.complete(null);
                }
            };
            t.start();
        }
    }

    public String toString() {
        return "[addr=" + this.uri + "]";
    }
}

