/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.utils;

public class ByteArrayUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("Parameter to be converted can not be null");
        }
        char[] converted = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            converted[i * 2] = HEX_CHARS[b >> 4 & 0xF];
            converted[i * 2 + 1] = HEX_CHARS[b & 0xF];
        }
        return String.valueOf(converted);
    }

    public static byte[] hexStringToBytes(String str) {
        char[] chars = str.toCharArray();
        if (chars.length % 2 != 0) {
            throw new IllegalArgumentException("The supplied character array must contain an even number of hex chars.");
        }
        byte[] response = new byte[chars.length / 2];
        for (int i = 0; i < response.length; ++i) {
            int posOne = i * 2;
            response[i] = (byte)(ByteArrayUtils.toByte(chars, posOne) << 4 | ByteArrayUtils.toByte(chars, posOne + 1));
        }
        return response;
    }

    private static byte toByte(char[] chars, int pos) {
        int response = Character.digit(chars[pos], 16);
        if (response < 0 || response > 15) {
            throw new IllegalArgumentException("Non-hex character '" + chars[pos] + "' at index=" + pos);
        }
        return (byte)response;
    }
}

