/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.standalone.broker;

import io.cloudevents.CloudEvent;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.storage.standalone.broker.Channel;
import org.apache.eventmesh.storage.standalone.broker.model.MessageEntity;
import org.apache.eventmesh.storage.standalone.broker.model.TopicMetadata;
import org.apache.eventmesh.storage.standalone.broker.task.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneBroker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandaloneBroker.class);
    private final ConcurrentHashMap<TopicMetadata, Channel> messageContainer = new ConcurrentHashMap();
    private final ConcurrentHashMap<TopicMetadata, Subscribe> subscribeContainer = new ConcurrentHashMap();

    private StandaloneBroker() {
    }

    public static StandaloneBroker getInstance() {
        return StandaloneBrokerInstanceHolder.INSTANCE;
    }

    public MessageEntity putMessage(String topicName, CloudEvent message) {
        TopicMetadata topicMetadata = new TopicMetadata(topicName);
        if (!this.messageContainer.containsKey(topicMetadata)) {
            throw new RuntimeException(String.format("The topic:%s is not created", topicName));
        }
        Channel channel = this.messageContainer.get(topicMetadata);
        if (channel.isClosed()) {
            throw new RuntimeException(String.format("The topic:%s is not subscribed", topicName));
        }
        MessageEntity messageEntity = new MessageEntity(new TopicMetadata(topicName), message);
        channel.getProvider().onData(messageEntity);
        return messageEntity;
    }

    public Channel createTopic(String topicName) {
        TopicMetadata topicMetadata = new TopicMetadata(topicName);
        return this.messageContainer.computeIfAbsent(topicMetadata, k -> new Channel(topicMetadata));
    }

    public CloudEvent takeMessage(String topicName) throws InterruptedException {
        return null;
    }

    public CloudEvent getMessage(String topicName) {
        return null;
    }

    public CloudEvent getMessage(String topicName, long offset) {
        return null;
    }

    public boolean checkTopicExist(String topicName) {
        return this.messageContainer.containsKey(new TopicMetadata(topicName));
    }

    public Channel createTopicIfAbsent(String topicName) {
        return this.createTopic(topicName);
    }

    public void deleteTopicIfExist(String topicName) {
        TopicMetadata topicMetadata = new TopicMetadata(topicName);
        Channel channel = this.createTopicIfAbsent(topicName);
        channel.shutdown();
        this.messageContainer.remove(topicMetadata);
    }

    public void subscribed(String topicName, Subscribe subscribe) {
        TopicMetadata topicMetadata = new TopicMetadata(topicName);
        if (this.subscribeContainer.containsKey(topicMetadata)) {
            log.warn("the topic:{} already subscribed", (Object)topicName);
            return;
        }
        Channel channel = this.getMessageContainer().get(topicMetadata);
        if (channel == null) {
            log.warn("the topic:{} is not created", (Object)topicName);
            return;
        }
        channel.setEventHandler(subscribe);
        channel.start();
        this.subscribeContainer.put(topicMetadata, subscribe);
    }

    @Generated
    public ConcurrentHashMap<TopicMetadata, Channel> getMessageContainer() {
        return this.messageContainer;
    }

    @Generated
    public ConcurrentHashMap<TopicMetadata, Subscribe> getSubscribeContainer() {
        return this.subscribeContainer;
    }

    private static class StandaloneBrokerInstanceHolder {
        private static final StandaloneBroker INSTANCE = new StandaloneBroker();

        private StandaloneBrokerInstanceHolder() {
        }
    }
}

