/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public final class StringUtils {
    private static final int DEFAULT_ABBREVIATE_MAX_WIDTH = 64;
    private static final String NULL_STRING = "null";
    private static final int INDEX_NOT_FOUND = -1;
    static final int[] INT_TABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    private StringUtils() {
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return StringUtils.isEmpty(str) ? defaultStr : str;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean hasLength(String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean hasText(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static int getLength(String string) {
        return StringUtils.getLength(string, 0);
    }

    public static int getLength(String string, int nullValue) {
        if (string == null) {
            return nullValue;
        }
        return string.length();
    }

    public static String toString(Object object) {
        if (object == null) {
            return NULL_STRING;
        }
        return object.toString();
    }

    public static boolean startWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    public static boolean contains(String str, String prefix) {
        return str != null && str.contains(prefix);
    }

    public static String abbreviate(String str) {
        return StringUtils.abbreviate(str, 64);
    }

    public static String abbreviate(String str, int maxWidth) {
        if (str == null) {
            return NULL_STRING;
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("negative maxWidth:" + maxWidth);
        }
        if (str.length() > maxWidth) {
            StringBuilder buffer = new StringBuilder(StringUtils.abbreviateBufferSize(maxWidth, str.length()));
            buffer.append(str, 0, maxWidth);
            StringUtils.appendAbbreviateMessage(buffer, str.length());
            return buffer.toString();
        }
        return str;
    }

    static int abbreviateBufferSize(int maxWidth, int strLength) {
        return maxWidth + "...()".length() + StringUtils.stringLength(strLength);
    }

    public static void appendAbbreviate(StringBuilder builder, String str, int maxWidth) {
        if (str == null) {
            return;
        }
        if (maxWidth < 0) {
            return;
        }
        if (str.length() > maxWidth) {
            builder.append(str, 0, maxWidth);
            StringUtils.appendAbbreviateMessage(builder, str.length());
        } else {
            builder.append(str);
        }
    }

    private static void appendAbbreviateMessage(StringBuilder buffer, int strLength) {
        buffer.append("...(");
        buffer.append(strLength);
        buffer.append(')');
    }

    static int stringLength(int x) {
        int i = 0;
        while (x > INT_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static List<String> tokenizeToStringList(String str, String delimiters) {
        return StringUtils.tokenizeToStringList(str, delimiters, true, true);
    }

    public static List<String> tokenizeToStringList(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (StringUtils.isEmpty(str)) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.isEmpty()) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = Math.max(increase, 0);
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : Math.min(max, 64)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }
}

