/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.core.util;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.CanalPacket;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.protocol.exception.CanalClientException;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class CanalMessageSerializerUtil {
    public static byte[] serializer(Message data, boolean filterTransactionEntry) {
        try {
            if (data != null && data.getId() != -1L) {
                if (data.isRaw() && !CollectionUtils.isEmpty((Collection)data.getRawEntries())) {
                    List rowEntries = data.getRawEntries();
                    int messageSize = 0;
                    messageSize += CodedOutputStream.computeInt64Size((int)1, (long)data.getId());
                    int dataSize = 0;
                    for (ByteString rowEntry : rowEntries) {
                        dataSize += CodedOutputStream.computeBytesSizeNoTag((ByteString)rowEntry);
                    }
                    messageSize += dataSize;
                    int size = 0;
                    size += CodedOutputStream.computeEnumSize((int)3, (int)CanalPacket.PacketType.MESSAGES.getNumber());
                    byte[] body = new byte[size += CodedOutputStream.computeTagSize((int)5) + CodedOutputStream.computeRawVarint32Size((int)(messageSize += 1 * rowEntries.size())) + messageSize];
                    CodedOutputStream output = CodedOutputStream.newInstance((byte[])body);
                    output.writeEnum(3, CanalPacket.PacketType.MESSAGES.getNumber());
                    output.writeTag(5, 2);
                    output.writeRawVarint32(messageSize);
                    output.writeInt64(1, data.getId());
                    for (ByteString rowEntry : rowEntries) {
                        output.writeBytes(2, rowEntry);
                    }
                    output.checkNoSpaceLeft();
                    return body;
                }
                if (!CollectionUtils.isEmpty((Collection)data.getEntries())) {
                    CanalPacket.Messages.Builder messageBuilder = CanalPacket.Messages.newBuilder();
                    for (CanalEntry.Entry entry : data.getEntries()) {
                        if (filterTransactionEntry && (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND)) continue;
                        messageBuilder.addMessages(entry.toByteString());
                    }
                    CanalPacket.Packet.Builder packetBuilder = CanalPacket.Packet.newBuilder();
                    packetBuilder.setType(CanalPacket.PacketType.MESSAGES);
                    packetBuilder.setVersion(1);
                    packetBuilder.setBody(messageBuilder.build().toByteString());
                    return packetBuilder.build().toByteArray();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error when serializing message to byte[] ");
        }
        return null;
    }

    public static Message deserializer(byte[] data) {
        return CanalMessageSerializerUtil.deserializer(data, false);
    }

    public static Message deserializer(byte[] data, boolean lazyParseEntry) {
        try {
            if (data == null) {
                return null;
            }
            CanalPacket.Packet p = CanalPacket.Packet.parseFrom((byte[])data);
            switch (p.getType()) {
                case MESSAGES: {
                    if (!p.getCompression().equals((Object)CanalPacket.Compression.NONE) && !p.getCompression().equals((Object)CanalPacket.Compression.COMPRESSIONCOMPATIBLEPROTO2)) {
                        throw new CanalClientException("compression is not supported in this connector");
                    }
                    CanalPacket.Messages messages = CanalPacket.Messages.parseFrom((ByteString)p.getBody());
                    Message result = new Message(messages.getBatchId());
                    if (lazyParseEntry) {
                        result.setRawEntries(messages.getMessagesList());
                        result.setRaw(true);
                    } else {
                        for (ByteString byteString : messages.getMessagesList()) {
                            result.addEntry(CanalEntry.Entry.parseFrom((ByteString)byteString));
                        }
                        result.setRaw(false);
                    }
                    return result;
                }
                case ACK: {
                    CanalPacket.Ack ack = CanalPacket.Ack.parseFrom((ByteString)p.getBody());
                    throw new CanalClientException("something goes wrong with reason: " + ack.getErrorMessage());
                }
            }
            throw new CanalClientException("unexpected packet type: " + p.getType());
        }
        catch (Exception e) {
            throw new CanalClientException("deserializer failed", (Throwable)e);
        }
    }
}

