/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.catalog;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.catalog.config.EventMeshCatalogClientConfig;
import org.apache.eventmesh.client.grpc.consumer.EventMeshGrpcConsumer;
import org.apache.eventmesh.client.selector.Selector;
import org.apache.eventmesh.client.selector.SelectorFactory;
import org.apache.eventmesh.client.selector.ServiceInstance;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.catalog.protos.CatalogGrpc;
import org.apache.eventmesh.common.protocol.catalog.protos.QueryOperationsRequest;
import org.apache.eventmesh.common.protocol.catalog.protos.QueryOperationsResponse;
import org.apache.eventmesh.common.utils.AssertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshCatalogClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshCatalogClient.class);
    private final transient EventMeshCatalogClientConfig clientConfig;
    private final transient EventMeshGrpcConsumer eventMeshGrpcConsumer;
    private final transient List<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();

    public EventMeshCatalogClient(EventMeshCatalogClientConfig clientConfig, EventMeshGrpcConsumer eventMeshGrpcConsumer) {
        this.clientConfig = clientConfig;
        this.eventMeshGrpcConsumer = eventMeshGrpcConsumer;
    }

    public void init() {
        Selector selector = SelectorFactory.get(this.clientConfig.getSelectorType());
        AssertUtils.notNull((Object)selector, (String)String.format("selector=%s not register.please check it.", this.clientConfig.getSelectorType()));
        ServiceInstance instance = selector.selectOne(this.clientConfig.getServerName());
        AssertUtils.notNull((Object)instance, (String)"catalog server is not running.please check it.");
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)instance.getHost(), (int)instance.getPort()).usePlaintext().build();
        CatalogGrpc.CatalogBlockingStub catalogClient = CatalogGrpc.newBlockingStub((Channel)channel);
        QueryOperationsRequest request = QueryOperationsRequest.newBuilder().setServiceName(this.clientConfig.getAppServerName()).build();
        QueryOperationsResponse response = catalogClient.queryOperations(request);
        log.info("received response: {}", (Object)response);
        List operations = response.getOperationsList();
        if (CollectionUtils.isEmpty((Collection)operations)) {
            return;
        }
        operations.forEach(operation -> {
            if ("subscribe".equals(operation.getType())) {
                SubscriptionItem subscriptionItem = new SubscriptionItem();
                subscriptionItem.setTopic(operation.getChannelName());
                subscriptionItem.setMode(this.clientConfig.getSubscriptionMode());
                subscriptionItem.setType(this.clientConfig.getSubscriptionType());
                this.subscriptionItems.add(subscriptionItem);
            }
        });
        this.eventMeshGrpcConsumer.subscribe(this.subscriptionItems);
    }

    public void destroy() {
        if (CollectionUtils.isNotEmpty(this.subscriptionItems)) {
            this.eventMeshGrpcConsumer.unsubscribe(this.subscriptionItems);
        }
    }
}

